package com.github.yafna.raspberry.grovepi.pi4j;

import com.github.yafna.raspberry.grovepi.GrovePiSequenceVoid;
import com.github.yafna.raspberry.grovepi.devices.GroveRgbLcd;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;

import java.io.IOException;

public class GroveLcdPi4J extends GroveRgbLcd {
	private final I2C text;

	public GroveLcdPi4J(Context pi4j) throws IOException {
		I2CConfigBuilder configtext = I2C.newConfigBuilder(pi4j);
		configtext.id("Grovepi-plus" + DISPLAY_TEXT_ADDR);
		configtext.name("My I2C Bus " + DISPLAY_TEXT_ADDR);
		configtext.bus(GrovePi4J.I2C_BUS);
		configtext.device(DISPLAY_TEXT_ADDR);
		I2CConfig c = configtext.build();
		text = pi4j.create(c);
		init();
	}

	@Override
	public void close() {
		text.close();
	}

	@Override
	public void execTEXT(GrovePiSequenceVoid sequence) throws IOException {
		synchronized (this) {
			sequence.execute(new IO(text));
		}
	}

	@Override
	public void execRGB(GrovePiSequenceVoid sequence) throws IOException {
		throw new IOException("Operation Not Supported");
	}

}
