package com.github.yafna.raspberry.grovepi.pi4j;

import com.github.yafna.raspberry.grovepi.GrovePiSequenceVoid;
import com.github.yafna.raspberry.grovepi.devices.GroveRgbLcd;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;

import java.io.IOException;

public class GroveRgbLcdPi4J extends GroveRgbLcd {
	private final I2C rgb;
	private final I2C text;

	public GroveRgbLcdPi4J(Context pi4j) throws IOException {
		I2CConfigBuilder configrgb = I2C.newConfigBuilder(pi4j);
		configrgb.id("Grovepi-plus" + DISPLAY_RGB_ADDR);
		configrgb.name("My I2C Bus " + DISPLAY_RGB_ADDR);
		configrgb.bus(GrovePi4J.I2C_BUS);
		configrgb.device(DISPLAY_RGB_ADDR);
		I2CConfig c = configrgb.build();
		//I2CConfigBuilder configrgb = (I2CConfigBuilder) I2C.newConfigBuilder(pi4j).id("Grovepi-plus" + DISPLAY_RGB_ADDR)
		//		.name("My I2C Bus " + DISPLAY_RGB_ADDR).bus(GrovePi4J.I2C_BUS).device(DISPLAY_RGB_ADDR).build();
		rgb = pi4j.create(c);
		I2CConfigBuilder configtext = I2C.newConfigBuilder(pi4j);
		configtext.id("Grovepi-plus" + DISPLAY_TEXT_ADDR);
		configtext.name("My I2C Bus " + DISPLAY_TEXT_ADDR);
		configtext.bus(GrovePi4J.I2C_BUS);
		configtext.device(DISPLAY_TEXT_ADDR);
		c = configtext.build();
		text = pi4j.create(c);
		init();
	}

	@Override
	public void close() {
		rgb.close();
		text.close();
	}

	@Override
	public void execRGB(GrovePiSequenceVoid sequence) throws IOException {
		synchronized (this) {
			sequence.execute(new IO(rgb));
		}
	}

	@Override
	public void execTEXT(GrovePiSequenceVoid sequence) throws IOException {
		synchronized (this) {
			sequence.execute(new IO(text));
		}
	}

}
