/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafna.raspberry.grovepi.pi4j;

import com.github.yafna.raspberry.grovepi.GroveIO;
import com.github.yafna.raspberry.grovepi.GrovePiSequenceVoid;
import com.github.yafna.raspberry.grovepi.devices.GroveRgbLcd;
import com.github.yafna.raspberry.grovepi.pi4j.IO;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import com.pi4j.io.i2c.I2CConfig;
import com.pi4j.io.i2c.I2CConfigBuilder;
import java.io.IOException;

public class GroveRgbLcdPi4J
extends GroveRgbLcd {
    private final I2C rgb;
    private final I2C text;

    public GroveRgbLcdPi4J(Context pi4j) throws IOException {
        I2CConfigBuilder configrgb = I2C.newConfigBuilder((Context)pi4j);
        configrgb.id("Grovepi-plus98");
        configrgb.name("My I2C Bus 98");
        configrgb.bus(Integer.valueOf(1));
        configrgb.device(Integer.valueOf(98));
        I2CConfig c = (I2CConfig)configrgb.build();
        this.rgb = pi4j.create(c);
        I2CConfigBuilder configtext = I2C.newConfigBuilder((Context)pi4j);
        configtext.id("Grovepi-plus62");
        configtext.name("My I2C Bus 62");
        configtext.bus(Integer.valueOf(1));
        configtext.device(Integer.valueOf(62));
        c = (I2CConfig)configtext.build();
        this.text = pi4j.create(c);
        this.init();
    }

    public void close() {
        this.rgb.close();
        this.text.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execRGB(GrovePiSequenceVoid sequence) throws IOException {
        GroveRgbLcdPi4J groveRgbLcdPi4J = this;
        synchronized (groveRgbLcdPi4J) {
            sequence.execute((GroveIO)new IO(this.rgb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execTEXT(GrovePiSequenceVoid sequence) throws IOException {
        GroveRgbLcdPi4J groveRgbLcdPi4J = this;
        synchronized (groveRgbLcdPi4J) {
            sequence.execute((GroveIO)new IO(this.text));
        }
    }
}

