/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.base.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.LocalDateTime;

public class Camera
extends Component {
    public static PicConfig.Builder newPictureConfigBuilder() {
        return new PicConfig.Builder();
    }

    public static VidConfig.Builder newVidConfigBuilder() {
        return new VidConfig.Builder();
    }

    public Camera() {
        this.init();
    }

    public void recordPicture() {
        this.recordPicture(Camera.newPictureConfigBuilder().outputPath("/home/pi/Pictures/picam.jpg").build());
    }

    public void recordPicture(PicConfig config) {
        this.logDebug("Taking Picture", new Object[0]);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("bash", "-c", config.asCommand());
        try {
            this.callBash(processBuilder);
        }
        catch (Exception e) {
            this.logException("Camera: Error while taking picture: ", e);
        }
    }

    public void recordVideo() {
        this.recordVideo(Camera.newVidConfigBuilder().outputPath("/home/pi/Videos/video.h264").recordTime(5000).build());
    }

    public void recordVideo(VidConfig config) {
        this.logDebug("Taking Video", new Object[0]);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("bash", "-c", config.asCommand());
        try {
            this.callBash(processBuilder);
        }
        catch (Exception e) {
            this.logException("Camera: Error while taking video: ", e);
        }
    }

    private void callBash(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        String line;
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            this.logError("Camera exited with error code : %s", exitCode);
        } else {
            this.logInfo("Camera finished successfully", new Object[0]);
        }
    }

    private void init() {
        this.logDebug("initialisation of camera", new Object[0]);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("bash", "-c", "libcamera-still");
        try {
            this.callBash(processBuilder);
        }
        catch (Exception e) {
            this.logException("Camera: Error at initialisation: ", e);
        }
    }

    public static class PicConfig {
        public final String outputPath;
        public final boolean useDate;
        public final int delay;
        public final int width;
        public final int height;
        public final int quality;
        public final PicEncoding encoding;
        public final boolean disablePreview;
        public final boolean allowFullscreenPreview;

        private PicConfig(Builder builder) {
            this.outputPath = builder.outputPath;
            this.useDate = builder.useDate;
            this.delay = builder.delay;
            this.width = builder.width;
            this.height = builder.height;
            this.quality = builder.quality;
            this.encoding = builder.encoding;
            this.disablePreview = builder.disablePreview;
            this.allowFullscreenPreview = builder.allowFullscreenPreview;
        }

        public String asCommand() {
            StringBuilder command = new StringBuilder("libcamera-still");
            if (this.useDate) {
                command.append(" -o '").append(this.outputPath).append(LocalDateTime.now()).append(".").append(this.encoding != null ? this.encoding : "jpg").append("'");
            } else {
                command.append(" -o '").append(this.outputPath).append("'");
            }
            if (this.delay != 0) {
                command.append(" -t ").append(this.delay);
            }
            if (this.width != 0) {
                command.append(" --width ").append(this.width);
            }
            if (this.height != 0) {
                command.append(" --height ").append(this.height);
            }
            if (this.quality != 0) {
                command.append(" -q ").append(this.quality);
            }
            if (this.encoding != null) {
                command.append(" --encoding ").append(this.encoding.getEncoding());
            }
            if (this.disablePreview) {
                command.append(" -n");
            }
            if (this.allowFullscreenPreview && !this.disablePreview) {
                command.append(" -f");
            }
            return command.toString();
        }

        public static class Builder {
            private String outputPath;
            private boolean useDate;
            private int delay;
            private int width;
            private int height;
            private int quality;
            private PicEncoding encoding;
            private boolean disablePreview;
            private boolean allowFullscreenPreview;

            public Builder outputPath(String outputPath) {
                this.outputPath = outputPath;
                return this;
            }

            public Builder useDate(boolean useDate) {
                this.useDate = useDate;
                return this;
            }

            public Builder delay(int delay) {
                this.delay = delay;
                return this;
            }

            public Builder width(int width) {
                this.width = width;
                return this;
            }

            public Builder height(int height) {
                this.height = height;
                return this;
            }

            public Builder quality(int quality) {
                if (quality < 0 || quality > 100) {
                    throw new IllegalArgumentException("quality must be between 0 and 100");
                }
                this.quality = quality;
                return this;
            }

            public Builder encoding(PicEncoding encoding) {
                this.encoding = encoding;
                return this;
            }

            public Builder disablePreview(boolean disablePreview) {
                this.disablePreview = disablePreview;
                return this;
            }

            public Builder allowFullscreenPreview(boolean allowFullscreenPreview) {
                this.allowFullscreenPreview = allowFullscreenPreview;
                return this;
            }

            public PicConfig build() {
                return new PicConfig(this);
            }
        }
    }

    public static class VidConfig {
        public final String outputPath;
        public final boolean useDate;
        public final int recordTime;
        public final VidEncoding encoding;

        private VidConfig(Builder builder) {
            this.outputPath = builder.outputPath;
            this.recordTime = builder.recordTime;
            this.encoding = builder.encoding;
            this.useDate = builder.useDate;
        }

        public String asCommand() {
            StringBuilder command = new StringBuilder("libcamera-vid -t " + this.recordTime);
            if (this.useDate) {
                command.append(" -o '").append(this.outputPath).append(LocalDateTime.now()).append(".").append(this.encoding != null ? this.encoding : "h264").append("'");
            } else {
                command.append(" -o '").append(this.outputPath).append("'");
            }
            if (this.encoding != null) {
                command.append(" --codec ").append(this.encoding.getEncoding());
            }
            return command.toString();
        }

        public static class Builder {
            private String outputPath;
            private int recordTime;
            private VidEncoding encoding;
            private boolean useDate;

            public Builder outputPath(String outputPath) {
                this.outputPath = outputPath;
                return this;
            }

            public Builder recordTime(int recordTime) {
                this.recordTime = recordTime;
                return this;
            }

            public Builder encoding(VidEncoding encoding) {
                this.encoding = encoding;
                return this;
            }

            public Builder useDate(boolean useDate) {
                this.useDate = useDate;
                return this;
            }

            public VidConfig build() {
                return new VidConfig(this);
            }
        }
    }

    public static enum VidEncoding {
        H264("h264"),
        MJPEG("mjpeg"),
        YUV420("yuv420");

        private final String encoding;

        private VidEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public static enum PicEncoding {
        PNG("png"),
        JPG("jpg"),
        RGB("rgb"),
        BMP("bmp"),
        YUV420("yuv420");

        private final String encoding;

        private PicEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

