/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components.base;

import java.time.Duration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Component {
    private static final Logger logger = Logger.getLogger("Pi4J Components");

    protected Component() {
    }

    public void reset() {
    }

    protected void logInfo(String msg, Object ... args) {
        logger.info(() -> String.format(msg, args));
    }

    protected void logError(String msg, Object ... args) {
        logger.severe(() -> String.format(msg, args));
    }

    protected void logDebug(String msg, Object ... args) {
        logger.fine(() -> String.format(msg, args));
    }

    protected void logException(String msg, Throwable exception) {
        logger.log(Level.SEVERE, msg, exception);
    }

    protected void delay(Duration duration) {
        try {
            long nanos = duration.toNanos();
            long millis = nanos / 1000000L;
            int remainingNanos = (int)(nanos % 1000000L);
            Thread.currentThread();
            Thread.sleep(millis, remainingNanos);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected <T> T asMock(Class<T> type, Object instance) {
        return type.cast(instance);
    }

    static {
        Level appropriateLevel = Level.INFO;
        System.setProperty("java.util.logging.SimpleFormatter.format", "%4$s: %5$s [%1$tl:%1$tM:%1$tS %1$Tp]%n");
        logger.setLevel(appropriateLevel);
        logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(appropriateLevel);
        logger.addHandler(handler);
    }
}

