/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components.base;

import com.pi4j.catalog.components.base.Component;
import com.pi4j.catalog.components.base.PIN;
import com.pi4j.context.Context;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.plugin.mock.provider.pwm.MockPwm;
import java.util.List;

public class PwmActuator
extends Component {
    protected static final List<PIN> AVAILABLE_PWM_PINS = List.of(PIN.PWM12, PIN.PWM13, PIN.PWM18, PIN.PWM19);
    protected final Pwm pwm;

    protected PwmActuator(Context pi4J, PwmConfig config) {
        if (AVAILABLE_PWM_PINS.stream().noneMatch(p -> p.getPin() == config.address().intValue())) {
            throw new IllegalArgumentException("Pin " + config.address() + " is not a PWM Pin");
        }
        this.pwm = pi4J.create(config);
    }

    @Override
    public void reset() {
        this.pwm.off();
    }

    public MockPwm mock() {
        return this.asMock(MockPwm.class, this.pwm);
    }
}

