/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components.base;

import com.pi4j.catalog.components.base.Component;
import com.pi4j.context.Context;
import com.pi4j.io.serial.FlowControl;
import com.pi4j.io.serial.Parity;
import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.SerialConfigBuilder;
import com.pi4j.io.serial.StopBits;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.function.Consumer;

public class SerialDevice
extends Component {
    private final Serial serial;
    private final Consumer<String> onNewData;
    private boolean continueReading = false;
    private Thread serialReaderThread;

    public SerialDevice(Context pi4j, Consumer<String> onNewData) {
        this.serial = pi4j.create((SerialConfig)((SerialConfigBuilder)((SerialConfigBuilder)Serial.newConfigBuilder((Context)pi4j).use_9600_N81().dataBits_8().parity(Parity.NONE).stopBits(StopBits._1).flowControl(FlowControl.NONE).id("my-serial")).device("/dev/ttyS0")).build());
        this.onNewData = onNewData;
        this.serial.open();
        while (!this.serial.isOpen()) {
            this.delay(Duration.ofMillis(250L));
        }
    }

    @Override
    public void reset() {
        this.stopReading();
        this.serial.close();
        super.reset();
    }

    public void stopReading() {
        this.continueReading = false;
        this.serialReaderThread = null;
    }

    public void startReading() {
        if (this.continueReading) {
            return;
        }
        this.continueReading = true;
        this.serialReaderThread = new Thread(() -> this.listenToSerialPort(), "SerialReader");
        this.serialReaderThread.setDaemon(true);
        this.serialReaderThread.start();
    }

    private void listenToSerialPort() {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.serial.getInputStream()));
        try {
            StringBuilder line = new StringBuilder();
            while (this.continueReading) {
                int available = this.serial.available();
                if (available > 0) {
                    for (int i = 0; i < available; ++i) {
                        byte b = (byte)br.read();
                        if (b < 32) {
                            if (line.length() <= 0) continue;
                            this.onNewData.accept(line.toString());
                            line = new StringBuilder();
                            continue;
                        }
                        line.append((char)b);
                    }
                    continue;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            this.logException("Error reading data from serial: ", e);
            e.printStackTrace();
        }
    }
}

