/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.Ads1115;
import com.pi4j.catalog.components.base.Component;
import java.util.function.Consumer;

public class Potentiometer
extends Component {
    private final Ads1115 ads1115;
    private final Range range;
    private final Ads1115.Channel channel;

    public Potentiometer(Ads1115 ads1115, Ads1115.Channel channel) {
        this(ads1115, channel, Range.ZERO_TO_ONE);
    }

    public Potentiometer(Ads1115 ads1115, Ads1115.Channel channel, Range range) {
        this.ads1115 = ads1115;
        this.range = range;
        this.channel = channel;
        this.logDebug("Potentiometer initialized", new Object[0]);
    }

    public double readCurrentVoltage() {
        return this.ads1115.readValue(this.channel);
    }

    public double readNormalizedValue() {
        return this.normalizeVoltage(this.readCurrentVoltage());
    }

    public void onNormalizedValueChange(Consumer<Double> onChange) {
        this.ads1115.onValueChange(this.channel, voltage -> onChange.accept(this.normalizeVoltage((double)voltage)));
    }

    @Override
    public void reset() {
        this.ads1115.resetChannel(this.channel);
    }

    private double normalizeVoltage(double voltage) {
        double maxRawValue = this.ads1115.maxRawValue(this.channel);
        double minRawValue = this.ads1115.minRawValue(this.channel);
        if (this.range == Range.ZERO_TO_ONE) {
            return Math.max(0.0, Math.min(voltage / (maxRawValue - minRawValue), 1.0));
        }
        double homeVoltage = (maxRawValue - minRawValue) * 0.5;
        return Math.max(-1.0, Math.min((voltage - homeVoltage) / homeVoltage, 1.0));
    }

    public static enum Range {
        ZERO_TO_ONE,
        MINUS_ONE_TO_ONE;

    }
}

