/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.SimpleButton;
import com.pi4j.catalog.components.base.Component;
import com.pi4j.catalog.components.base.PIN;
import com.pi4j.context.Context;
import com.pi4j.plugin.mock.provider.gpio.digital.MockDigitalInput;
import java.time.Duration;

public class Joystick
extends Component {
    private final SimpleButton bNorth;
    private final SimpleButton bWest;
    private final SimpleButton bSouth;
    private final SimpleButton bEast;
    private final SimpleButton bPush;

    public Joystick(Context pi4j, PIN addrNorth, PIN addrEast, PIN addrSouth, PIN addrWest, PIN addrPush) {
        this.bNorth = new SimpleButton(pi4j, addrNorth, false);
        this.bWest = new SimpleButton(pi4j, addrWest, false);
        this.bSouth = new SimpleButton(pi4j, addrSouth, false);
        this.bEast = new SimpleButton(pi4j, addrEast, false);
        this.bPush = addrPush != null ? new SimpleButton(pi4j, addrPush, false) : null;
    }

    public Joystick(Context pi4j, PIN addrNorth, PIN addrEast, PIN addrSouth, PIN addrWest) {
        this(pi4j, addrNorth, addrEast, addrSouth, addrWest, null);
    }

    public boolean isNorth() {
        return this.bNorth.isDown();
    }

    public boolean isWest() {
        return this.bWest.isDown();
    }

    public boolean isSouth() {
        return this.bSouth.isDown();
    }

    public boolean isEast() {
        return this.bEast.isDown();
    }

    public boolean isPushed() {
        return this.pushIsPresent() && this.bPush.isDown();
    }

    public boolean isCenter() {
        return this.bEast.isUp() && this.bWest.isUp() && this.bNorth.isUp() && this.bSouth.isUp() && (!this.pushIsPresent() || this.pushIsPresent() && this.bPush.isUp());
    }

    public void onNorth(Runnable task) {
        this.bNorth.onDown(task);
    }

    public void whileNorth(Runnable task, Duration delay) {
        this.bNorth.whilePressed(task, delay);
    }

    public void onWest(Runnable task) {
        this.bWest.onDown(task);
    }

    public void whileWest(Runnable task, Duration delay) {
        this.bWest.whilePressed(task, delay);
    }

    public void onSouth(Runnable task) {
        this.bSouth.onDown(task);
    }

    public void whileSouth(Runnable task, Duration delay) {
        this.bSouth.whilePressed(task, delay);
    }

    public void onEast(Runnable task) {
        this.bEast.onDown(task);
    }

    public void onCenter(Runnable task) {
        this.bNorth.onUp(task);
        this.bSouth.onUp(task);
        this.bEast.onUp(task);
        this.bWest.onUp(task);
    }

    public void whileEast(Runnable task, Duration delay) {
        this.bEast.whilePressed(task, delay);
    }

    public void onPushDown(Runnable handler) {
        if (!this.pushIsPresent()) {
            throw new IllegalStateException("No runnable on pushDown allowed if no push button is present");
        }
        this.bPush.onDown(handler);
    }

    public void onPushUp(Runnable task) {
        if (!this.pushIsPresent()) {
            throw new IllegalStateException("No runnable on pushDown allowed if no push button is present");
        }
        this.bPush.onUp(task);
    }

    public void whilePushed(Runnable task, Duration delay) {
        if (!this.pushIsPresent()) {
            throw new IllegalStateException("No push button available, can't do a whilePushed");
        }
        this.bPush.whilePressed(task, delay);
    }

    @Override
    public void reset() {
        this.bNorth.reset();
        this.bWest.reset();
        this.bSouth.reset();
        this.bEast.reset();
        if (this.pushIsPresent()) {
            this.bPush.reset();
        }
    }

    public boolean isInInitialState() {
        return this.bNorth.isInInitialState() && this.bWest.isInInitialState() && this.bSouth.isInInitialState() && this.bEast.isInInitialState() && (!this.pushIsPresent() || this.pushIsPresent() && this.bPush.isInInitialState());
    }

    private boolean pushIsPresent() {
        return this.bPush != null;
    }

    MockDigitalInput mockNorth() {
        return this.bNorth.mock();
    }

    MockDigitalInput mockSouth() {
        return this.bSouth.mock();
    }

    MockDigitalInput mockEast() {
        return this.bEast.mock();
    }

    MockDigitalInput mockWest() {
        return this.bWest.mock();
    }

    MockDigitalInput mockPush() {
        if (this.pushIsPresent()) {
            return this.bPush.mock();
        }
        throw new IllegalStateException("No push button available, no DigitalInput available");
    }
}

