/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.base.I2CDevice;
import com.pi4j.context.Context;
import com.pi4j.io.i2c.I2C;
import java.time.Duration;

public class LcdDisplay
extends I2CDevice {
    private static final byte LCD_CLEAR_DISPLAY = 1;
    private static final byte LCD_RETURN_HOME = 2;
    private static final byte LCD_SCROLL_RIGHT = 30;
    private static final byte LCD_SCROLL_LEFT = 24;
    private static final byte LCD_ENTRY_MODE_SET = 4;
    private static final byte LCD_DISPLAY_CONTROL = 8;
    private static final byte LCD_CURSOR_SHIFT = 16;
    private static final byte LCD_FUNCTION_SET = 32;
    private static final byte LCD_SET_CGRAM_ADDR = 64;
    private static final byte LCD_SET_DDRAM_ADDR = -128;
    private static final byte LCD_ENTRY_RIGHT = 0;
    private static final byte LCD_ENTRY_LEFT = 2;
    private static final byte LCD_ENTRY_SHIFT_INCREMENT = 1;
    private static final byte LCD_ENTRY_SHIFT_DECREMENT = 0;
    private static final byte LCD_DISPLAY_ON = 4;
    private static final byte LCD_DISPLAY_OFF = 0;
    private static final byte LCD_CURSOR_ON = 2;
    private static final byte LCD_CURSOR_OFF = 0;
    private static final byte LCD_BLINK_ON = 1;
    private static final byte LCD_BLINK_OFF = 0;
    private static final byte LCD_DISPLAY_MOVE = 8;
    private static final byte LCD_CURSOR_MOVE = 0;
    private static final byte LCD_8BIT_MODE = 16;
    private static final byte LCD_4BIT_MODE = 0;
    private static final byte LCD_2LINE = 8;
    private static final byte LCD_1LINE = 0;
    private static final byte LCD_5x10DOTS = 4;
    private static final byte LCD_5x8DOTS = 0;
    private static final byte LCD_BACKLIGHT = 8;
    private static final byte LCD_NO_BACKLIGHT = 0;
    private static final byte En = 4;
    private static final byte Rw = 2;
    private static final byte Rs = 1;
    private static final byte[] LCD_ROW_OFFSETS = new byte[]{0, 64, 20, 84};
    private static final int DEFAULT_DEVICE = 39;
    private final int rows;
    private final int columns;
    private boolean backlight;

    public LcdDisplay(Context pi4j) {
        this(pi4j, 2, 16, 39);
    }

    public LcdDisplay(Context pi4j, int rows, int columns) {
        this(pi4j, rows, columns, 39);
    }

    public LcdDisplay(Context pi4j, int rows, int columns, int device) {
        super(pi4j, device, "PCF8574AT backed LCD");
        this.rows = rows;
        this.columns = columns;
    }

    @Override
    protected void init(I2C i2c) {
        this.sendLcdTwoPartsCommand((byte)3);
        this.sendLcdTwoPartsCommand((byte)3);
        this.sendLcdTwoPartsCommand((byte)3);
        this.sendLcdTwoPartsCommand((byte)2);
        this.sendLcdTwoPartsCommand((byte)40);
        this.sendLcdTwoPartsCommand((byte)12);
        this.sendLcdTwoPartsCommand((byte)6);
        this.clearDisplay();
        this.setDisplayBacklight(true);
    }

    public void setDisplayBacklight(boolean backlightEnabled) {
        this.backlight = backlightEnabled;
        this.sendCommand(this.backlight ? (byte)8 : 0);
    }

    public void clearDisplay() {
        this.moveCursorHome();
        this.sendLcdTwoPartsCommand((byte)1);
    }

    public void moveCursorHome() {
        this.sendLcdTwoPartsCommand((byte)2);
    }

    public void off() {
        this.sendCommand((byte)0);
    }

    public void displayLineOfText(String text, int line) {
        this.displayLineOfText(text, line, 0);
    }

    public void centerTextInLine(String text, int line) {
        this.displayLineOfText(text, line, (int)((double)(this.columns - text.length()) * 0.5));
    }

    public void displayLineOfText(String text, int line, int position) {
        if (text.length() + position > this.columns) {
            this.logInfo("Text '%s' too long, cut to %d characters", text, this.columns - position);
            text = text.substring(0, this.columns - position);
        }
        if (line > this.rows || line < 0) {
            this.logError("Wrong line id '%d'. Only %d lines possible", line, this.rows);
        } else {
            this.setCursorToPosition(line, 0);
            for (int i = 0; i < position; ++i) {
                this.writeCharacter(' ');
            }
            for (char character : text.toCharArray()) {
                this.writeCharacter(character);
            }
            for (int i = 0; i < this.columns - text.length(); ++i) {
                this.writeCharacter(' ');
            }
        }
    }

    public void displayText(String text) {
        int j;
        this.logDebug("Display in LCD: '%s'", text);
        int currentLine = 0;
        StringBuilder[] texts = new StringBuilder[this.rows];
        for (j = 0; j < this.rows; ++j) {
            texts[j] = new StringBuilder(this.rows);
        }
        for (int i = 0; i < text.length(); ++i) {
            if (currentLine > this.rows - 1) {
                this.logInfo("Text too long, remaining '%s' will not be displayed", text.substring(i));
                break;
            }
            if (text.charAt(i) == '\n') {
                ++currentLine;
                continue;
            }
            if (texts[currentLine].length() >= this.columns) {
                ++currentLine;
                if (text.charAt(i) == ' ') {
                    ++i;
                }
            }
            if (currentLine >= this.rows) continue;
            texts[currentLine].append(text.charAt(i));
        }
        for (j = 0; j < this.rows; ++j) {
            this.displayLineOfText(texts[j].toString(), j);
        }
    }

    public void writeCharacter(char character) {
        this.sendLcdTwoPartsCommand((byte)character, (byte)1);
    }

    public void writeCharacter(char character, int line, int pos) {
        this.setCursorToPosition(line, pos);
        this.sendLcdTwoPartsCommand((byte)character, (byte)1);
    }

    private void displayLine(String text, int pos) {
        this.sendLcdTwoPartsCommand((byte)(128 + pos));
        for (int i = 0; i < text.length(); ++i) {
            this.writeCharacter(text.charAt(i));
        }
    }

    public void clearLine(int line) {
        if (line > this.rows || line < 1) {
            throw new IllegalArgumentException("Wrong line id. Only " + this.rows + " lines possible");
        }
        this.displayLine(" ".repeat(this.columns), LCD_ROW_OFFSETS[line - 1]);
    }

    public void setCursorToPosition(int line, int pos) {
        if (line > this.rows - 1 || line < 0) {
            throw new IllegalArgumentException("Line out of range. Display has only " + this.rows + "x" + this.columns + " Characters!");
        }
        if (pos < 0 || pos > this.columns - 1) {
            throw new IllegalArgumentException("Line out of range. Display has only " + this.rows + "x" + this.columns + " Characters!");
        }
        this.sendLcdTwoPartsCommand((byte)(0xFFFFFF80 | pos + LCD_ROW_OFFSETS[line]));
    }

    public void createCharacter(int location, byte[] character) {
        if (character.length != 8) {
            throw new IllegalArgumentException("Array has invalid length. Character is only 5x8 Digits. Only a array with length 8 is allowed");
        }
        if (location > 7 || location < 1) {
            throw new IllegalArgumentException("Invalid memory location. Range 1-7 allowed. Value: " + location);
        }
        this.sendLcdTwoPartsCommand((byte)(0x40 | location << 3));
        for (int i = 0; i < 8; ++i) {
            this.sendLcdTwoPartsCommand(character[i], (byte)1);
        }
    }

    public void scrollRight() {
        this.sendLcdTwoPartsCommand((byte)30);
    }

    public void scrollLeft() {
        this.sendLcdTwoPartsCommand((byte)24);
    }

    @Override
    public void reset() {
        this.clearDisplay();
        this.off();
    }

    private void sendLcdTwoPartsCommand(byte cmd) {
        this.sendLcdTwoPartsCommand(cmd, (byte)0);
    }

    private void sendLcdTwoPartsCommand(byte cmd, byte mode) {
        this.writeFourBits((byte)(mode | cmd & 0xF0));
        this.writeFourBits((byte)(mode | cmd << 4 & 0xF0));
    }

    private void writeFourBits(byte data) {
        int backlightStatus = this.backlight ? 8 : 0;
        this.write((byte)(data | 4 | backlightStatus));
        this.write((byte)(data & 0xFFFFFFFB | backlightStatus));
        this.delay(Duration.ofNanos(50000L));
    }
}

