/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.base.Component;
import com.pi4j.catalog.components.base.SerialDevice;
import com.pi4j.context.Context;
import java.util.Locale;
import java.util.function.Consumer;

public class SerialGps
extends Component {
    private static final double MIN_DISTANCE_M = 1.0;
    private final SerialDevice device;
    private final Consumer<GeoPosition> onNewPosition;
    private final Consumer<Double> onNewAltitude;
    private int numberOfSatellites = 0;
    private GeoPosition lastReportedPosition = new GeoPosition(0.0, 0.0);
    private double lastReportedAltitude = -999.0;

    public SerialGps(Context pi4j, Consumer<GeoPosition> onNewPosition, Consumer<Double> onNewAltitude) {
        this.onNewPosition = onNewPosition;
        this.onNewAltitude = onNewAltitude;
        this.device = new SerialDevice(pi4j, this::handleNewData);
    }

    public void start() {
        this.device.startReading();
        this.logInfo("reading GPS data started", new Object[0]);
    }

    public void stop() {
        this.device.stopReading();
        this.logInfo("Stopped reading GPS data", new Object[0]);
    }

    @Override
    public void reset() {
        this.device.reset();
        super.reset();
        this.logInfo("Stopped reading GPS data", new Object[0]);
    }

    private void handleNewData(String line) {
        this.logDebug("Serial reader delivered: '%s'", line);
        String[] data = line.split(",");
        switch (data[0]) {
            case "$GPGGA": {
                this.handleFixData(data);
                break;
            }
            case "$GPGLL": {
                this.handlePosition(data[1], data[2], data[3], data[4]);
            }
        }
    }

    private void handleFixData(String[] data) {
        try {
            String satelliteString = data[7];
            if (satelliteString.contains(".")) {
                satelliteString = satelliteString.substring(0, satelliteString.indexOf(46));
            }
            int n = this.numberOfSatellites = satelliteString.isEmpty() ? 0 : Integer.parseInt(satelliteString);
            if (this.numberOfSatellites == 0) {
                this.logInfo("no satellites in view", new Object[0]);
            }
            this.logDebug("Number of satellites in use: %d", this.numberOfSatellites);
            this.handlePosition(data[2], data[3], data[4], data[5]);
            this.handleAltitude(data[9]);
        }
        catch (Exception e) {
            this.logError("unknown NMEA sentence: '%s'", String.join((CharSequence)",", data));
        }
    }

    private void handleAltitude(String altitudeString) {
        double altitude;
        if (this.numberOfSatellites >= 3 && this.onNewAltitude != null && !altitudeString.isEmpty() && Math.abs((altitude = Double.parseDouble(altitudeString)) - this.lastReportedAltitude) >= 1.0) {
            this.lastReportedAltitude = altitude;
            this.logDebug("Current altitude, %.1f m", altitude);
            this.onNewAltitude.accept(altitude);
        }
    }

    private void handlePosition(String lat, String northOrSouth, String lng, String eastOrWest) {
        if (this.numberOfSatellites >= 3 && this.onNewPosition != null) {
            double latitude = 0.0;
            if (!lat.isEmpty()) {
                int degree = Integer.parseInt(lat.substring(0, 2));
                double minutes = Double.parseDouble(lat.substring(2));
                latitude = (double)degree + minutes / 60.0;
            }
            double longitude = 0.0;
            if (!lng.isEmpty()) {
                int degree = Integer.parseInt(lng.substring(0, 3));
                double minutes = Double.parseDouble(lng.substring(3));
                longitude = (double)degree + minutes / 60.0;
            }
            if (latitude != 0.0 && northOrSouth.equals("S")) {
                latitude = -latitude;
            }
            if (longitude != 0.0 && eastOrWest.equals("W")) {
                longitude = -longitude;
            }
            GeoPosition pos = new GeoPosition(latitude, longitude);
            double moved = this.lastReportedPosition.distance(pos);
            this.logDebug("Moved %.2f m", moved);
            if (moved >= 1.0) {
                this.logDebug("GPS: new position: %s", pos.dms());
                this.lastReportedPosition = pos;
                this.onNewPosition.accept(pos);
            } else {
                this.logDebug("No significant movement", new Object[0]);
            }
        }
    }

    public record GeoPosition(double latitude, double longitude) {
        public String dms() {
            return this.format(this.latitude, this.longitude);
        }

        public double distance(GeoPosition otherPosition) {
            double lon1 = this.longitude;
            double lon2 = otherPosition.longitude;
            double lat1 = this.latitude;
            double lat2 = otherPosition.latitude;
            double theta = lon1 - lon2;
            return this.rad2deg(Math.acos(Math.sin(this.deg2rad(lat1)) * Math.sin(this.deg2rad(lat2)) + Math.cos(this.deg2rad(lat1)) * Math.cos(this.deg2rad(lat2)) * Math.cos(this.deg2rad(theta)))) * 60.0 * 1.1515 * 1609.344;
        }

        private double deg2rad(double deg) {
            return deg * Math.PI / 180.0;
        }

        private double rad2deg(double rad) {
            return rad * 180.0 / Math.PI;
        }

        private String format(double latitude, double longitude) {
            String latCompassDirection = latitude > 0.0 ? "N" : "S";
            String lonCompassDirection = longitude > 0.0 ? "E" : "W";
            return String.format("%s%s, %s%s", this.getDMS(latitude), latCompassDirection, this.getDMS(longitude), lonCompassDirection);
        }

        private String getDMS(double value) {
            double absValue = Math.abs(value);
            int degree = (int)absValue;
            int minutes = (int)((absValue - (double)degree) * 60.0);
            double seconds = (absValue - (double)degree - (double)minutes / 60.0) * 3600.0;
            return String.format("%d\u00b0%d\u2032%s\u2033", degree, minutes, String.format(Locale.ENGLISH, "%.4f", seconds));
        }
    }
}

