/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.catalog.components;

import com.pi4j.catalog.components.base.DigitalSensor;
import com.pi4j.catalog.components.base.PIN;
import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalInput;
import com.pi4j.io.gpio.digital.DigitalInputConfig;
import com.pi4j.io.gpio.digital.DigitalInputConfigBuilder;
import com.pi4j.io.gpio.digital.DigitalState;
import com.pi4j.io.gpio.digital.DigitalStateChangeListener;
import com.pi4j.io.gpio.digital.PullResistance;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SimpleButton
extends DigitalSensor {
    private final boolean inverted;
    private Runnable onUp;
    private Runnable onDown;
    private Runnable whileDown;
    private Duration whilePressedDelay;
    private final Runnable whileDownWorker = () -> {
        while (this.isDown()) {
            this.delay(this.whilePressedDelay);
            if (!this.isDown() || this.whileDown == null) continue;
            this.logDebug("whileDown triggered", new Object[0]);
            this.whileDown.run();
        }
    };
    private ExecutorService executor;

    public SimpleButton(Context pi4j, PIN address, boolean inverted) {
        this(pi4j, address, inverted, 10000L);
    }

    public SimpleButton(Context pi4j, PIN address, boolean inverted, long debounce) {
        super(pi4j, (DigitalInputConfig)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)((DigitalInputConfigBuilder)DigitalInput.newConfigBuilder((Context)pi4j).id("BCM" + address)).name("Button #" + address)).address(Integer.valueOf(address.getPin()))).debounce(Long.valueOf(debounce)).pull(inverted ? PullResistance.PULL_UP : PullResistance.PULL_DOWN).build());
        this.inverted = inverted;
        this.digitalInput.addListener(new DigitalStateChangeListener[]{digitalStateChangeEvent -> {
            DigitalState state = this.getState();
            this.logDebug("Button switched to '%s'", state);
            switch (state) {
                case HIGH: {
                    if (this.onDown != null) {
                        this.logDebug("onDown triggered", new Object[0]);
                        this.onDown.run();
                    }
                    if (this.whileDown == null) break;
                    this.executor.submit(this.whileDownWorker);
                    break;
                }
                case LOW: {
                    if (this.onUp == null) break;
                    this.logDebug("onUp triggered", new Object[0]);
                    this.onUp.run();
                    break;
                }
                case UNKNOWN: {
                    this.logError("Button is in State UNKNOWN", new Object[0]);
                }
            }
        }});
    }

    public boolean isDown() {
        return this.getState() == DigitalState.HIGH;
    }

    public boolean isUp() {
        return this.getState() == DigitalState.LOW;
    }

    public void onDown(Runnable task) {
        this.onDown = task;
    }

    public void onUp(Runnable task) {
        this.onUp = task;
    }

    public void whilePressed(Runnable task, Duration delay) {
        this.whileDown = task;
        this.whilePressedDelay = delay;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (task != null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
    }

    public boolean isInInitialState() {
        return this.onDown == null && this.onUp == null && this.whileDown == null && this.executor == null;
    }

    @Override
    public void reset() {
        this.onDown = null;
        this.onUp = null;
        this.whileDown = null;
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    private DigitalState getState() {
        return switch (this.digitalInput.state()) {
            case DigitalState.HIGH -> {
                if (this.inverted) {
                    yield DigitalState.LOW;
                }
                yield DigitalState.HIGH;
            }
            case DigitalState.LOW -> {
                if (this.inverted) {
                    yield DigitalState.HIGH;
                }
                yield DigitalState.LOW;
            }
            default -> DigitalState.UNKNOWN;
        };
    }
}

