/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.core.adaptive;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.annotations.Adaptive;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.ReconfigurationFailed;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.Reconfigure;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.internal.InternalEvent;

public abstract class AdaptiveProtocol
extends GenericProtocol {
    private final Map<String, Method> adaptiveSetters;

    public AdaptiveProtocol(String protoName, short protoId) throws HandlerRegistrationException {
        super(protoName, protoId);
        this.registerRequests();
        this.adaptiveSetters = new HashMap<String, Method>();
        this.assertAndPopulateAdaptiveSetters();
    }

    public AdaptiveProtocol(String protoName, short protoId, BlockingQueue<InternalEvent> policy) throws HandlerRegistrationException {
        super(protoName, protoId, policy);
        this.registerRequests();
        this.adaptiveSetters = new HashMap<String, Method>();
        this.assertAndPopulateAdaptiveSetters();
    }

    private final void registerRequests() throws HandlerRegistrationException {
        this.registerRequestHandler((short)704, this::uponReconfigureRequest);
    }

    private final void assertAndPopulateAdaptiveSetters() {
        Field[] fields;
        for (Field field : fields = ((Object)((Object)this)).getClass().getFields()) {
            if (!field.isAnnotationPresent(Adaptive.class)) continue;
            String setterCanonicalString = this.getCanonicalSetterName(field.getName());
            try {
                Method setter = ((Object)((Object)this)).getClass().getMethod(setterCanonicalString, field.getType());
                if (Modifier.isPublic(setter.getModifiers())) {
                    throw new RuntimeException("Adaptive field " + field.getName() + " does not have a public setter method " + setterCanonicalString);
                }
                Class<?>[] paramTypes = setter.getParameterTypes();
                if (paramTypes.length != 1) {
                    throw new RuntimeException("Adaptive field " + field.getName() + " does not have a setter method with a single parameter");
                }
                this.adaptiveSetters.put(field.getName(), setter);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Adaptive field " + field.getName() + " does not have a setter method " + setterCanonicalString);
            }
        }
    }

    protected void uponReconfigureRequest(Reconfigure request, short protoID) {
        Iterator<Map.Entry<String, Object>> iterator = request.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> property = iterator.next();
            String fieldName = property.getKey();
            Object value = property.getValue();
            Class<?> valueType = value.getClass();
            Method setter = this.adaptiveSetters.get(fieldName);
            if (setter == null) {
                ReconfigurationFailed notification = new ReconfigurationFailed(this.getProtoId(), request, "Field " + fieldName + " is not an adaptive field in " + ((Object)((Object)this)).getClass().getCanonicalName());
                this.triggerNotification(notification);
                continue;
            }
            Class<?>[] paramTypes = setter.getParameterTypes();
            assert (paramTypes.length == 1);
            Class<?> paramType = paramTypes[0];
            if (!paramType.isAssignableFrom(valueType)) {
                ReconfigurationFailed notification = new ReconfigurationFailed(this.getProtoId(), request, "The given value does not match the field " + fieldName + "'s type in " + ((Object)((Object)this)).getClass().getCanonicalName() + ". Expected " + paramType.getCanonicalName() + " but got " + valueType.getCanonicalName() + " instead.");
                this.triggerNotification(notification);
                continue;
            }
            try {
                setter.invoke((Object)this, valueType.cast(value));
            }
            catch (ClassCastException e) {
                ReconfigurationFailed notification = new ReconfigurationFailed(this.getProtoId(), request, "The given value does not match the field " + fieldName + "'s type in " + ((Object)((Object)this)).getClass().getCanonicalName(), e);
                this.triggerNotification(notification);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
    }

    private String getCanonicalSetterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }
}

