/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.rc.eventual.antientropy.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.crdts.delta.generic.DeltaCRDT;
import pt.unl.fct.di.novasys.babel.crdts.generic.GenericCRDT;
import pt.unl.fct.di.novasys.babel.crdts.utils.CRDTsTypes;
import pt.unl.fct.di.novasys.babel.crdts.utils.Utils;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class DeltaMessage
extends ProtoMessage {
    public static final short MSG_CODE = 603;
    private DeltaCRDT delta;
    private int seqNumber;
    private Host origin;
    private String objectID;
    public static final ISerializer<DeltaMessage> serializer = new ISerializer<DeltaMessage>(){

        public void serialize(DeltaMessage msg, ByteBuf out) throws IOException {
            Utils.encodeUTF8((String)msg.objectID, (ByteBuf)out);
            out.writeInt(msg.seqNumber);
            Host.serializer.serialize((Object)msg.origin, out);
            CRDTsTypes.serializer.serialize((Object)msg.delta.getType(), out);
            msg.delta.serialize(out);
        }

        public DeltaMessage deserialize(ByteBuf in) throws IOException {
            String objectID = Utils.decodeUTF8((ByteBuf)in);
            int seqNumber = in.readInt();
            Host origin = (Host)Host.serializer.deserialize(in);
            CRDTsTypes type = (CRDTsTypes)CRDTsTypes.serializer.deserialize(in);
            if (!type.isOfFlavor(CRDTsTypes.FLAVOR.DELTA)) {
                throw new IOException("CRDT received is not delta-based!");
            }
            DeltaCRDT delta = (DeltaCRDT)GenericCRDT.deserializeDataType((CRDTsTypes)type, (ByteBuf)in);
            return new DeltaMessage(objectID, delta, seqNumber, origin);
        }
    };

    public DeltaMessage(String objectID, DeltaCRDT delta, int seqNumber, Host origin) {
        super((short)603);
        this.delta = delta;
        this.seqNumber = seqNumber;
        this.origin = origin;
        this.objectID = objectID;
    }

    public DeltaCRDT getDelta() {
        return this.delta;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public Host getOrigin() {
        return this.origin;
    }

    public String getObjectID() {
        return this.objectID;
    }
}

