/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.rc.eventual.antientropy.utils;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import pt.unl.fct.di.novasys.babel.crdts.delta.generic.DeltaCRDT;
import pt.unl.fct.di.novasys.network.data.Host;

public class DeltaState {
    private SortedMap<Integer, DeltaCRDT> buffer;
    private SortedMap<Host, Integer> acks;
    private int seqNumber;
    private String crdtID;

    public DeltaState(String crdtID) {
        this.crdtID = crdtID;
        this.buffer = new TreeMap<Integer, DeltaCRDT>();
        this.acks = new TreeMap<Host, Integer>();
        this.seqNumber = 0;
    }

    public SortedMap<Integer, DeltaCRDT> getBuffer() {
        return this.buffer;
    }

    public DeltaCRDT getCRDT(int seqNumber) {
        return (DeltaCRDT)this.buffer.get(seqNumber);
    }

    public void putCRDT(DeltaCRDT crdt) {
        this.buffer.put(this.seqNumber, crdt);
        this.incSeqNumber();
    }

    public void putCRDTList(List<DeltaCRDT> deltas) {
        for (DeltaCRDT delta : deltas) {
            this.buffer.put(this.seqNumber, delta);
            this.incSeqNumber();
        }
    }

    public int getMinBufferSeqNum() {
        if (this.buffer.isEmpty()) {
            return -1;
        }
        return this.buffer.firstKey();
    }

    public int getMaxBufferSeqNum() {
        if (this.buffer.isEmpty()) {
            return -1;
        }
        return this.buffer.lastKey();
    }

    public SortedMap<Host, Integer> getAcks() {
        return this.acks;
    }

    public Integer getACK(Host peer) {
        Integer ack = (Integer)this.acks.get(peer);
        return ack == null ? -1 : ack;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public String getCrdtID() {
        return this.crdtID;
    }

    public void incSeqNumber() {
        ++this.seqNumber;
    }

    public void updateAcks(Host origin, int ackSeqNumber) {
        Integer seqNumberReceiver = (Integer)this.acks.get(origin);
        int maxSeqNumber = 0;
        if (seqNumberReceiver != null) {
            maxSeqNumber = Math.max(ackSeqNumber, seqNumberReceiver);
        }
        this.acks.put(origin, maxSeqNumber);
    }
}

