/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.eagerpush.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.UUID;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.messages.IdentifiableProtoMessage;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.BroadcastDelivery;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class GossipMessage
extends IdentifiableProtoMessage {
    public static final short MSG_CODE = 1601;
    private final Timestamp timestamp;
    private final Host sender;
    private final byte[] payload;
    private short hopCount;
    private short protoID;
    public static final ISerializer<GossipMessage> serializer = new ISerializer<GossipMessage>(){

        public void serialize(GossipMessage msg, ByteBuf out) throws IOException {
            out.writeLong(msg.getMID().getMostSignificantBits());
            out.writeLong(msg.getMID().getLeastSignificantBits());
            Host.serializer.serialize((Object)msg.sender, out);
            out.writeLong(msg.timestamp.getTime());
            out.writeInt(msg.payload.length);
            out.writeBytes(msg.payload);
            out.writeShort((int)msg.hopCount);
            out.writeShort((int)msg.protoID);
        }

        public GossipMessage deserialize(ByteBuf in) throws IOException {
            UUID mid = new UUID(in.readLong(), in.readLong());
            Host origin = (Host)Host.serializer.deserialize(in);
            long t = in.readLong();
            byte[] payload = new byte[in.readInt()];
            in.readBytes(payload);
            short h = in.readShort();
            short pid = in.readShort();
            return new GossipMessage(mid, t, origin, payload, h, pid);
        }
    };

    public GossipMessage(Timestamp t, Host s, byte[] p, short pID) {
        super((short)1601);
        this.timestamp = Timestamp.from(t.toInstant());
        this.sender = new Host(s.getAddress(), s.getPort());
        this.payload = (byte[])p.clone();
        this.hopCount = 0;
        this.protoID = pID;
    }

    private GossipMessage(UUID mid, long t, Host s, byte[] p, short h, short pID) {
        super((short)1601, mid);
        this.timestamp = new Timestamp(t);
        this.sender = s;
        this.payload = p;
        this.hopCount = h;
        this.protoID = pID;
    }

    private GossipMessage(GossipMessage m) {
        super((short)1601, m.getMID());
        this.timestamp = m.timestamp;
        this.sender = m.sender;
        this.payload = m.payload;
        this.hopCount = m.hopCount;
        this.protoID = m.protoID;
    }

    public BroadcastDelivery generateDeliveryNotification(short sourceProtoID) {
        return new BroadcastDelivery(this.sender, (byte[])this.payload.clone(), new Timestamp(this.timestamp.getTime()));
    }

    public GossipMessage clone() {
        return new GossipMessage(this);
    }

    public short getHopCount() {
        return this.hopCount;
    }

    public void setHopCount(short hopCount) {
        this.hopCount = hopCount;
    }

    public short getProtoID() {
        return this.protoID;
    }

    public void setProtoID(short protoID) {
        this.protoID = protoID;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Host getSender() {
        return this.sender;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public short incrementHopCount() {
        this.hopCount = (short)(this.hopCount + 1);
        return this.hopCount;
    }

    public String toString() {
        return "GosipMessage{sender=" + String.valueOf(this.sender) + ", mid=" + this.getMID().toString() + ", timestamp=" + String.valueOf(this.timestamp) + ", payload size=" + this.payload.length + ", hopCount=" + this.hopCount + ", protoID=" + this.protoID + "}";
    }
}

