/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.antientropy.messages;

import com.google.common.hash.BloomFilter;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class AntiEntrophyAnnounce
extends ProtoMessage {
    public static final short MSG_CODE = 901;
    private final Host sender;
    private final int setSize;
    private final BloomFilter<String> receivedMessages;
    public static final ISerializer<AntiEntrophyAnnounce> serializer = new ISerializer<AntiEntrophyAnnounce>(){

        public void serialize(AntiEntrophyAnnounce t, ByteBuf out) throws IOException {
            Host.serializer.serialize((Object)t.getSender(), out);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(byteArrayOutputStream);
            output.writeObject(t.receivedMessages);
            byte[] representation = byteArrayOutputStream.toByteArray();
            output.close();
            out.writeInt(representation.length);
            out.writeBytes(representation);
        }

        public AntiEntrophyAnnounce deserialize(ByteBuf in) throws IOException {
            Host h = (Host)Host.serializer.deserialize(in);
            int setSize = in.readInt();
            byte[] representation = new byte[in.readInt()];
            in.readBytes(representation);
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(representation));
            BloomFilter filter = null;
            try {
                filter = (BloomFilter)input.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(1);
            }
            return new AntiEntrophyAnnounce(h, (BloomFilter<String>)filter, setSize);
        }
    };

    public AntiEntrophyAnnounce(Host sender, BloomFilter<String> bf, int setSize) {
        super((short)901);
        this.sender = sender;
        this.receivedMessages = bf;
        this.setSize = setSize;
    }

    public Host getSender() {
        return this.sender;
    }

    public int getSetSize() {
        return this.setSize;
    }

    public boolean contains(String id) {
        return this.receivedMessages.mightContain((Object)id);
    }

    public String toString() {
        return "AntiEntropyAnnounce{sender=" + String.valueOf(this.sender) + ", setSize=" + this.setSize + ", receivedMessages=" + this.receivedMessages.toString() + "}";
    }
}

