package pt.unl.fct.di.novasys.babel.protocols.antientropy.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.common.hash.BloomFilter;

import io.netty.buffer.ByteBuf;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.protocols.secure.membership.Peer;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class AntiEntrophyAnnounce extends ProtoMessage {

    public final static short MSG_CODE = 901;

	private final Peer sender;
    private final int setSize;
    private final BloomFilter<String> receivedMessages;

	private static final Logger logger = LogManager.getLogger(AntiEntrophyAnnounce.class);

	public AntiEntrophyAnnounce(Peer sender, BloomFilter<String> bf, int setSize) {
		super(AntiEntrophyAnnounce.MSG_CODE);
		this.sender = sender;
		this.receivedMessages = bf;
		this.setSize = setSize;		
	}
	
	public Peer getSender() {
		return this.sender;
	}

	public int getSetSize() {
		return this.setSize;
	}
	
	public boolean contains(String id) {
		return this.receivedMessages.mightContain(id);
	}

	@Override
    public String toString() {
        return "AntiEntropyAnnounce{" +
                "sender="+sender +
                ", setSize=" + setSize +
                ", receivedMessages=" + receivedMessages.toString() +
                '}';
    }

    public static final ISerializer<AntiEntrophyAnnounce> serializer = new ISerializer<AntiEntrophyAnnounce>() {
		
		@Override
		public void serialize(AntiEntrophyAnnounce t, ByteBuf out) throws IOException {
			Peer.serializer.serialize(t.getSender(), out);
			out.writeInt(t.setSize);
			ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
	        ObjectOutputStream output = new ObjectOutputStream(byteArrayOutputStream);
	        output.writeObject(t.receivedMessages);
	        byte[] representation = byteArrayOutputStream.toByteArray();
	        logger.debug("Serialized bloom filter to a " + representation.length + "bytes (numebr of elementes is: " + t.getSetSize() + ") ");
	        output.close();
	        out.writeInt(representation.length);
	        out.writeBytes(representation);       
		}
		
		@SuppressWarnings("unchecked")
		@Override
		public AntiEntrophyAnnounce deserialize(ByteBuf in) throws IOException {
			Peer peer = Peer.serializer.deserialize(in);
			int setSize = in.readInt();
			byte[] representation = new byte[in.readInt()];
			in.readBytes(representation);
			ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(representation));
			BloomFilter<String> filter = null;
			try {
				filter = (BloomFilter<String>) input.readObject();
			} catch (ClassNotFoundException | IOException e) {
				e.printStackTrace();
				System.exit(1); //TODO: this has to be verified and checked!
			}
			return new AntiEntrophyAnnounce(peer, filter, setSize);	
		}
	};
}
