/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.hyparview.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.net.UnknownHostException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class NeighborReplyMessage
extends ProtoMessage {
    public static final short MSG_CODE = 406;
    private final boolean reply;
    private final boolean hasSubstitute;
    private final Host substitute;
    public static final ISerializer<NeighborReplyMessage> serializer = new ISerializer<NeighborReplyMessage>(){

        public void serialize(NeighborReplyMessage m, ByteBuf out) throws IOException {
            out.writeBoolean(m.reply);
            out.writeBoolean(m.hasSubstitute);
            if (m.hasSubstitute) {
                Host.serializer.serialize((Object)m.substitute, out);
            }
        }

        public NeighborReplyMessage deserialize(ByteBuf in) throws UnknownHostException, IOException {
            boolean reply = in.readBoolean();
            boolean hasSubstitute = in.readBoolean();
            if (!hasSubstitute) {
                return new NeighborReplyMessage(reply);
            }
            Host payload = (Host)Host.serializer.deserialize(in);
            return new NeighborReplyMessage(reply, payload);
        }
    };

    public NeighborReplyMessage(boolean reply) {
        super((short)406);
        this.reply = reply;
        this.substitute = null;
        this.hasSubstitute = false;
    }

    public NeighborReplyMessage(boolean reply, Host substitute) {
        super((short)406);
        this.reply = reply;
        this.substitute = substitute;
        this.hasSubstitute = true;
    }

    public String toString() {
        return "NeighborReplyMessage{reply=" + this.reply + "}";
    }

    public boolean isTrue() {
        return this.reply;
    }

    public Host getSubstitute() {
        return this.substitute;
    }
}

