/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.dii.novasys.babel.protocols.floodbcast.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.UUID;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class BCastMessage
extends ProtoMessage {
    public static final short MSG_CODE = 501;
    private final UUID mid;
    private final Timestamp timestamp;
    private final Host sender;
    private final byte[] payload;
    private short hopCount;
    private short protoID;
    public static final ISerializer<BCastMessage> serializer = new ISerializer<BCastMessage>(){

        public void serialize(BCastMessage msg, ByteBuf out) throws IOException {
            out.writeLong(msg.mid.getMostSignificantBits());
            out.writeLong(msg.mid.getLeastSignificantBits());
            Host.serializer.serialize((Object)msg.sender, out);
            out.writeLong(msg.timestamp.getTime());
            out.writeShort(msg.payload.length);
            out.writeBytes(msg.payload);
            out.writeShort((int)msg.hopCount);
            out.writeShort((int)msg.protoID);
        }

        public BCastMessage deserialize(ByteBuf in) throws IOException {
            UUID mid = new UUID(in.readLong(), in.readLong());
            Host origin = (Host)Host.serializer.deserialize(in);
            long t = in.readLong();
            byte[] payload = new byte[in.readShort()];
            in.readBytes(payload);
            short h = in.readShort();
            short pid = in.readShort();
            return new BCastMessage(mid, t, origin, payload, h, pid);
        }
    };

    public BCastMessage(Timestamp t, Host s, byte[] p, short pID) {
        super((short)501);
        this.mid = UUID.randomUUID();
        this.timestamp = Timestamp.from(t.toInstant());
        this.sender = new Host(s.getAddress(), s.getPort());
        this.payload = (byte[])p.clone();
        this.hopCount = 0;
        this.protoID = pID;
    }

    private BCastMessage(UUID mid, long t, Host s, byte[] p, short h, short pID) {
        super((short)501);
        this.mid = mid;
        this.timestamp = new Timestamp(t);
        this.sender = s;
        this.payload = p;
        this.hopCount = h;
        this.protoID = pID;
    }

    private BCastMessage(BCastMessage m) {
        super((short)501);
        this.mid = m.mid;
        this.timestamp = m.timestamp;
        this.sender = m.sender;
        this.payload = m.payload;
        this.hopCount = m.hopCount;
        this.protoID = m.protoID;
    }

    public BCastMessage clone() {
        return new BCastMessage(this);
    }

    public UUID getMID() {
        return this.mid;
    }

    public short getHopCount() {
        return this.hopCount;
    }

    public void setHopCount(short hopCount) {
        this.hopCount = hopCount;
    }

    public short getProtoID() {
        return this.protoID;
    }

    public void setProtoID(short protoID) {
        this.protoID = protoID;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Host getSender() {
        return this.sender;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public short incrementHopCount() {
        this.hopCount = (short)(this.hopCount + 1);
        return this.hopCount;
    }

    public String toString() {
        return "BCastMessage{sender=" + String.valueOf(this.sender) + ", timestamp=" + String.valueOf(this.timestamp) + ", payload size=" + this.payload.length + ", hopCount=" + this.hopCount + ", protoID=" + this.protoID + "}";
    }
}

