/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.hyparview.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class ShuffleMessage
extends ProtoMessage {
    public static final short MSG_CODE = 1407;
    private short seqnum;
    private short ttl;
    private final List<Host> sample;
    private Host origin;
    public static final ISerializer<ShuffleMessage> serializer = new ISerializer<ShuffleMessage>(){

        public void serialize(ShuffleMessage msg, ByteBuf out) throws IOException {
            Host.serializer.serialize((Object)msg.origin, out);
            out.writeShort((int)msg.seqnum);
            out.writeShort((int)msg.ttl);
            out.writeShort(msg.sample.size());
            for (Host h : msg.sample) {
                Host.serializer.serialize((Object)h, out);
            }
        }

        public ShuffleMessage deserialize(ByteBuf in) throws IOException {
            Host origin = (Host)Host.serializer.deserialize(in);
            short seqnum = in.readShort();
            short ttl = in.readShort();
            short size = in.readShort();
            ArrayList<Host> payload = new ArrayList<Host>(size);
            for (short i = 0; i < size; i = (short)(i + 1)) {
                payload.add((Host)Host.serializer.deserialize(in));
            }
            return new ShuffleMessage(origin, payload, ttl, seqnum);
        }
    };

    public ShuffleMessage(Host self, Collection<Host> peers, short ttl, short seqnum) {
        super((short)1407);
        this.origin = self;
        this.sample = new ArrayList<Host>(peers);
        this.ttl = ttl;
        this.seqnum = seqnum;
    }

    public List<Host> getFullSample() {
        ArrayList<Host> full = new ArrayList<Host>(this.sample);
        full.add(this.origin);
        return full;
    }

    public String toString() {
        return "ShuffleMessage{origin=" + String.valueOf(this.origin) + ", seqN=" + this.seqnum + ", ttl=" + this.ttl + ", sample=" + String.valueOf(this.sample) + "}";
    }

    public Host getOrigin() {
        return this.origin;
    }

    public short getTtl() {
        return this.ttl;
    }

    public short decrementTtl() {
        short s = this.ttl;
        this.ttl = (short)(s - 1);
        return s;
    }

    public short getSeqnum() {
        return this.seqnum;
    }
}

