/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.protocols.hyparview.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class ShuffleReplyMessage
extends ProtoMessage {
    public static final short MSG_CODE = 1408;
    private short seqnum;
    private final List<Host> sample;
    public static final ISerializer<ShuffleReplyMessage> serializer = new ISerializer<ShuffleReplyMessage>(){

        public void serialize(ShuffleReplyMessage msg, ByteBuf out) throws IOException {
            out.writeShort((int)msg.seqnum);
            out.writeShort(msg.sample.size());
            for (Host h : msg.sample) {
                Host.serializer.serialize((Object)h, out);
            }
        }

        public ShuffleReplyMessage deserialize(ByteBuf in) throws IOException {
            short seqnum = in.readShort();
            short size = in.readShort();
            ArrayList<Host> payload = new ArrayList<Host>(size);
            for (short i = 0; i < size; i = (short)(i + 1)) {
                payload.add((Host)Host.serializer.deserialize(in));
            }
            return new ShuffleReplyMessage(payload, seqnum);
        }
    };

    public ShuffleReplyMessage(Collection<Host> peers, short seqnum) {
        super((short)1408);
        this.sample = new ArrayList<Host>(peers);
        this.seqnum = seqnum;
    }

    public String toString() {
        return "ShuffleReplyMessage{seqN=" + this.seqnum + ", sample=" + String.valueOf(this.sample) + "}";
    }

    public List<Host> getSample() {
        return this.sample;
    }

    public short getSeqnum() {
        return this.seqnum;
    }
}

