package pt.unl.fct.di.tardis.babel.iot.controlprotocol;

import java.io.IOException;
import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.github.yafna.raspberry.grovepi.pi4j.GroveLcdPi4J;
import com.github.yafna.raspberry.grovepi.pi4j.GroveLedMatrix;
import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;

import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;

public class IoTControlProtocol extends GenericProtocol {

	private static final Logger logger = LogManager.getLogger(IoTControlProtocol.class);
	
	public final static short PROTO_ID = 9999;
	public final static String PROTO_NAME = "IoTControlProtocol";

	private final Context pi4j;
	private GroveLedMatrix matrix;
	private GroveLcdPi4J lcd;
	
	private final byte[] tardisLogo = {	(byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255,  
										(byte) 255, (byte) 255, (byte) 183, (byte) 142, (byte) 174, (byte) 250, (byte) 255, (byte) 255, 
										(byte) 255, (byte) 183, (byte) 106, (byte) 142, (byte) 174, (byte) 209, (byte) 250, (byte) 255,
										(byte) 255, (byte)  78, (byte) 106, (byte) 178, (byte) 210, (byte) 205, (byte) 241, (byte) 255,
										(byte) 255, (byte)  78, (byte)  69, (byte) 142, (byte) 174, (byte) 205, (byte) 241, (byte) 255, 
										(byte) 255, (byte) 183, (byte)  69, (byte) 142, (byte) 173, (byte) 205, (byte) 250, (byte) 255,
										(byte) 255, (byte) 255, (byte) 183, (byte) 142, (byte) 174, (byte) 250, (byte) 255, (byte) 255, 
										(byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255, (byte) 255};
	
	public IoTControlProtocol() {
		super(IoTControlProtocol.PROTO_NAME, IoTControlProtocol.PROTO_ID);
		
		final PiGpio piGpio = PiGpio.newNativeInstance();
		
		pi4j = Pi4J.newContextBuilder()
                .noAutoDetect()
                .add(new RaspberryPiPlatform() {
                    @Override
                    protected String[] getProviders() {
                        return new String[] {};
                    }
                })
                .add(PiGpioDigitalInputProvider.newInstance(piGpio),
                     PiGpioDigitalOutputProvider.newInstance(piGpio),
                     PiGpioPwmProvider.newInstance(piGpio),
                     PiGpioSerialProvider.newInstance(piGpio),
                     PiGpioSpiProvider.newInstance(piGpio),
                     LinuxFsI2CProvider.newInstance())
                .build();
		
		try {
			this.matrix = new GroveLedMatrix(pi4j);
		} catch (IOException e) {
			logger.error("Could not initialize the LedMatrix: ", e);
			this.matrix = null;
		}

		try {
			this.lcd = new GroveLcdPi4J(pi4j);
		} catch (IOException e) {
			logger.error("Could not initialize the LCD: ", e);
			this.lcd = null;
		}
		
		if(this.matrix != null) {
			this.matrix.setAllColor((byte) 255, (byte) 0, (byte) 0);
		}
		
	}
	
	@Override
	public void init(Properties props) throws HandlerRegistrationException, IOException {
		if(this.matrix != null) {
			this.matrix.loadSnapshot(tardisLogo);
		}
		
		if(this.lcd != null) {
			this.lcd.setText("Welcome to the TaRDIS messaging app with IoT example... hold on...");
		}
	}

}
