/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocol;

import com.github.yafna.raspberry.grovepi.pi4j.GroveLcdPi4J;
import com.github.yafna.raspberry.grovepi.pi4j.GroveLedMatrix;
import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.platform.Platform;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;
import com.pi4j.provider.Provider;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.IdentifiableMessageNotification;
import pt.unl.fct.di.novasys.babel.protocols.general.notifications.ChannelAvailableNotification;
import pt.unl.fct.di.tardis.babel.iot.controlprotocol.requests.ShowAnimationRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocol.requests.ShowEmojiRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocol.requests.ShowTextRequest;

public class IoTControlProtocol
extends GenericProtocol {
    private static final Logger logger = LogManager.getLogger(IoTControlProtocol.class);
    public static final short PROTO_ID = 8000;
    public static final String PROTO_NAME = "IoTControlProtocol";
    private final Context pi4j;
    private GroveLedMatrix matrix;
    private GroveLcdPi4J lcd;
    private final byte[] tardisLogo = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -73, -114, -82, -6, -1, -1, -1, -73, 106, -114, -82, -47, -6, -1, -1, 78, 106, -78, -46, -51, -15, -1, -1, 78, 69, -114, -82, -51, -15, -1, -1, -73, 69, -114, -83, -51, -6, -1, -1, -1, -73, -114, -82, -6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private byte[] lastState;
    private byte[] colors = new byte[]{82, 0, 127, -61, 24, -36};
    private int currentColor;
    private int currentX;
    private int currentY;
    private int maxCoordinate;

    public IoTControlProtocol() throws HandlerRegistrationException {
        super(PROTO_NAME, (short)8000);
        PiGpio piGpio = PiGpio.newNativeInstance();
        this.pi4j = (Context)Pi4J.newContextBuilder().noAutoDetect().add(new Platform[]{new RaspberryPiPlatform(this){

            protected String[] getProviders() {
                return new String[0];
            }
        }}).add(new Provider[]{PiGpioDigitalInputProvider.newInstance((PiGpio)piGpio), PiGpioDigitalOutputProvider.newInstance((PiGpio)piGpio), PiGpioPwmProvider.newInstance((PiGpio)piGpio), PiGpioSerialProvider.newInstance((PiGpio)piGpio), PiGpioSpiProvider.newInstance((PiGpio)piGpio), LinuxFsI2CProvider.newInstance()}).build();
        try {
            this.matrix = new GroveLedMatrix(this.pi4j);
        }
        catch (IOException e) {
            logger.error("Could not initialize the LedMatrix: ", (Throwable)e);
            this.matrix = null;
        }
        try {
            this.lcd = new GroveLcdPi4J(this.pi4j);
        }
        catch (IOException e) {
            logger.error("Could not initialize the LCD: ", (Throwable)e);
            this.lcd = null;
        }
        if (this.matrix != null) {
            this.matrix.clearDisplay();
            this.lastState = this.matrix.getSnapshot();
            this.matrix.setAllColor((byte)-1, (byte)0, (byte)0);
        }
        this.registerRequestHandler((short)8003, this::handleShowAnimationRequest);
        this.registerRequestHandler((short)8002, this::handleShowEmojiRequest);
        this.registerRequestHandler((short)8001, this::handleShowTextRequest);
        this.subscribeNotification((short)1, this::handleChannelAvailableNotificaiton);
        this.subscribeNotification((short)502, this::handleIdentifiableMessageNotification);
        this.currentColor = 0;
        this.currentX = 0;
        this.currentY = 0;
        this.maxCoordinate = 8;
    }

    public void init(Properties props) throws HandlerRegistrationException, IOException {
        if (this.matrix != null) {
            this.matrix.loadSnapshot(this.tardisLogo);
        }
        if (this.lcd != null) {
            this.lcd.setText("Welcome to the TaRDIS messaging app with IoT example... hold on...");
        }
    }

    private void handleShowAnimationRequest(ShowAnimationRequest req, short protoId) {
        this.matrix.displayColorAnimation(req.getAnimation());
    }

    private void handleShowEmojiRequest(ShowEmojiRequest req, short protoId) {
        this.matrix.displayEmoji(req.getEmoji());
    }

    private void handleShowTextRequest(ShowTextRequest req, short protoId) {
        this.lcd.setText(req.getText());
    }

    private void handleChannelAvailableNotificaiton(ChannelAvailableNotification not, short protoId) {
        this.matrix.setAllColor((byte)0, (byte)-1, (byte)0);
    }

    private void handleIdentifiableMessageNotification(IdentifiableMessageNotification not, short portoId) {
        this.matrix.loadSnapshot(this.lastState);
        try {
            this.matrix.setPixelColor(this.currentX, this.currentY, this.colors[this.currentColor]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.currentColor;
        if (this.currentColor == this.colors.length) {
            this.currentColor = 0;
        }
        ++this.currentY;
        if (this.currentY == this.maxCoordinate) {
            this.currentY = 0;
            ++this.currentX;
            if (this.currentX == this.maxCoordinate) {
                this.currentX = 0;
            }
        }
        this.lastState = this.matrix.getSnapshot();
    }
}

