package pt.unl.fct.di.tardis.babel.iot.api.requests;

import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;

public class IoTPeriodicMeasurementRequest extends ProtoRequest {

	public static final short REQUEST_ID = 4001;
	
	private final DeviceHandle handle;
	private final long period; //Period of measurement in milliseconds
	
	public IoTPeriodicMeasurementRequest(DeviceHandle handle, long p) {
		this(REQUEST_ID, handle, p);
	}
	
	public IoTPeriodicMeasurementRequest(short id, DeviceHandle handle, long p) {
		super(id);
		this.handle = handle;
		this.period = p;
	}
	
	public DeviceHandle getDeviceHandle() {
		return this.handle;
	}
	
	public long getPeriod() {
		return this.period;
	}

}
