package pt.unl.fct.di.tardis.babel.iot.api.requests;

import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;

public class IoTReactiveMeasurementRequest<T> extends ProtoRequest {

	public static final short REQUEST_ID = 4002;
	
	private final DeviceHandle handle;
	private final T threshold;
	
	public IoTReactiveMeasurementRequest(DeviceHandle handle, T threshold) {
		this(REQUEST_ID, handle, threshold);
	}
	
	public IoTReactiveMeasurementRequest(short id, DeviceHandle handle,  T threshold) {
		super(id);
		this.handle = handle;
		this.threshold = threshold;
	}
	
	public DeviceHandle getDeviceHandle() {
		return this.handle;
	}
	
	public T getThreshold() {
		return this.threshold;
	}

}
