/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols;

import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.exception.Pi4JException;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.platform.Platform;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;
import com.pi4j.provider.Provider;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.Babel;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoReply;
import pt.unl.fct.di.novasys.iot.device.Device;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLcd;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLedMatrix;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.api.DeviceType;
import pt.unl.fct.di.tardis.babel.iot.api.replies.RegisterIoTDeviceReply;
import pt.unl.fct.di.tardis.babel.iot.api.requests.RegisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.UnregisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.SetDisplayColorRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowAnimationRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowDisplayRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowEmojiRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowTextRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.utils.I2CScanner;

public class I2COutputControlProtocol
extends GenericProtocol {
    public static final String PROTOCOL_NAME = "I2COutputControlProtocol";
    public static final short PROTOCOL_ID = 4000;
    private static final Logger logger = LogManager.getLogger(I2COutputControlProtocol.class);
    private final Context pi4j;
    private GroveLedMatrix matrix;
    private GroveLcd lcd;
    private final I2CScanner scanner;
    private final AtomicInteger ids;
    private final HashMap<Device, Short> deviceIds;
    private final HashMap<Short, Device> deviceIdsMapping;
    private final HashMap<DeviceHandle, Device> deviceMappings;
    private final HashMap<Device, Set<DeviceHandle>> deviceHandles;

    public I2COutputControlProtocol() {
        super(PROTOCOL_NAME, (short)4000);
        PiGpio piGpio = PiGpio.newNativeInstance();
        this.pi4j = (Context)Pi4J.newContextBuilder().noAutoDetect().add(new Platform[]{new RaspberryPiPlatform(this){

            protected String[] getProviders() {
                return new String[0];
            }
        }}).add(new Provider[]{PiGpioDigitalInputProvider.newInstance((PiGpio)piGpio), PiGpioDigitalOutputProvider.newInstance((PiGpio)piGpio), PiGpioPwmProvider.newInstance((PiGpio)piGpio), PiGpioSerialProvider.newInstance((PiGpio)piGpio), PiGpioSpiProvider.newInstance((PiGpio)piGpio), LinuxFsI2CProvider.newInstance()}).build();
        this.scanner = I2CScanner.getInstance();
        this.ids = new AtomicInteger(0);
        this.deviceIds = new HashMap();
        this.deviceIdsMapping = new HashMap();
        this.deviceMappings = new HashMap();
        this.deviceHandles = new HashMap();
    }

    public void init(Properties props) throws HandlerRegistrationException, IOException {
        this.registerRequestHandler((short)4000, this::handleRegisterIoTDeviceRequest);
        this.registerRequestHandler((short)4005, this::handleUnregisterIoTDeviceRequest);
        this.registerRequestHandler((short)8004, this::handleSetDisplayColorRequest);
        this.registerRequestHandler((short)8003, this::handleShowAnimationRequest);
        this.registerRequestHandler((short)8002, this::handleShowEmojiRequest);
        this.registerRequestHandler((short)8001, this::handleShowTextRequest);
    }

    public void handleRegisterIoTDeviceRequest(RegisterIoTDeviceRequest req, short protocolId) {
        Set<DeviceType> devices = this.scanner.getConnectedDevices();
        if (devices.contains(req.getDeviceType())) {
            this.sendReply((ProtoReply)new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), RegisterIoTDeviceReply.ERR_CODE.DEVICE_NOT_AVAILABLE, "Device is not connected"), protocolId);
        }
        DeviceHandle handle = null;
        switch (req.getDeviceType()) {
            case GROVE_LCD: {
                if (this.lcd == null) {
                    try {
                        this.lcd = new GroveLcd(this.pi4j);
                    }
                    catch (IOException e) {
                        logger.error("Could not initialize the LCD: ", (Throwable)e);
                        this.sendReply((ProtoReply)new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), RegisterIoTDeviceReply.ERR_CODE.DEVICE_INIT_ERR, "IOException: " + e.getMessage()), protocolId);
                        this.lcd = null;
                    }
                    catch (Pi4JException pe) {
                        logger.error("Could not initialize the LCD: ", (Throwable)pe);
                        this.sendReply((ProtoReply)new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), RegisterIoTDeviceReply.ERR_CODE.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                        this.lcd = null;
                    }
                    if (this.lcd == null) {
                        return;
                    }
                    short id = (short)this.ids.incrementAndGet();
                    this.deviceIds.put((Device)this.lcd, id);
                    this.deviceIdsMapping.put(id, (Device)this.matrix);
                    this.lcd.setText("Device initialized.");
                }
                if (this.lcd == null) {
                    return;
                }
                handle = new DeviceHandle(DeviceType.GROVE_LCD, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.lcd).shortValue(), req.getDeviceAlias());
                this.deviceMappings.put(handle, (Device)this.lcd);
                if (!this.deviceHandles.containsKey(this.lcd)) {
                    this.deviceHandles.put((Device)this.lcd, new HashSet());
                }
                this.deviceHandles.get(this.lcd).add(handle);
                this.sendReply((ProtoReply)new RegisterIoTDeviceReply(handle), protocolId);
                break;
            }
            case GROVE_LED_MATRIX: {
                if (this.matrix == null) {
                    try {
                        this.matrix = new GroveLedMatrix(this.pi4j);
                    }
                    catch (IOException e) {
                        logger.error("Could not initialize the LedMatrix: ", (Throwable)e);
                        this.sendReply((ProtoReply)new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), RegisterIoTDeviceReply.ERR_CODE.DEVICE_INIT_ERR, "IOException: " + e.getMessage()), protocolId);
                        this.matrix = null;
                    }
                    catch (Pi4JException pe) {
                        logger.error("Could not initialize the LedMatrix: ", (Throwable)pe);
                        this.sendReply((ProtoReply)new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), RegisterIoTDeviceReply.ERR_CODE.DEVICE_INIT_ERR, "Pi4JException: " + pe.getMessage()), protocolId);
                        this.matrix = null;
                    }
                    if (this.matrix == null) {
                        return;
                    }
                    short id = (short)this.ids.incrementAndGet();
                    this.deviceIds.put((Device)this.matrix, id);
                    this.deviceIdsMapping.put(id, (Device)this.matrix);
                    this.matrix.clearDisplay();
                    this.matrix.setAllColor((byte)-1, (byte)0, (byte)0);
                }
                if (this.matrix == null) {
                    return;
                }
                handle = new DeviceHandle(DeviceType.GROVE_LED_MATRIX, protocolId, Babel.getInstance().getProtoNameById(protocolId), this.deviceIds.get(this.matrix).shortValue(), req.getDeviceAlias());
                this.deviceMappings.put(handle, (Device)this.matrix);
                if (!this.deviceHandles.containsKey(this.matrix)) {
                    this.deviceHandles.put((Device)this.matrix, new HashSet());
                }
                this.deviceHandles.get(this.matrix).add(handle);
                this.sendReply((ProtoReply)new RegisterIoTDeviceReply(handle), protocolId);
                break;
            }
            default: {
                this.sendReply((ProtoReply)new RegisterIoTDeviceReply(req.getDeviceType(), req.getDeviceAlias(), RegisterIoTDeviceReply.ERR_CODE.UNKNOWN_DEVICE, "Unknown DeviceType"), protocolId);
            }
        }
    }

    public void handleUnregisterIoTDeviceRequest(UnregisterIoTDeviceRequest req, short protocolId) {
    }

    public void handleSetDisplayColorRequest(SetDisplayColorRequest req, short protocolId) {
        DeviceHandle h = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.setAllColor((byte)req.getRed(), (byte)req.getGreen(), (byte)req.getBlue());
        }
    }

    public void handleShowDisplayRequest(ShowDisplayRequest req, short protocolId) {
        DeviceHandle h = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.loadSnapshot(req.getDisplay());
        }
    }

    public void handleShowAnimationRequest(ShowAnimationRequest req, short protocolId) {
        DeviceHandle h = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.displayColorAnimation(req.getAnimation());
        }
    }

    public void handleShowEmojiRequest(ShowEmojiRequest req, short protocolId) {
        DeviceHandle h = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h.getDeviceID());
        if (d instanceof GroveLedMatrix && this.matrix != null) {
            this.matrix.displayEmoji(req.getEmoji());
        }
    }

    public void handleShowTextRequest(ShowTextRequest req, short protocolId) {
        DeviceHandle h = req.getDeviceHandle();
        Device d = this.deviceIdsMapping.get(h.getDeviceID());
        if (d instanceof GroveLcd && this.lcd != null) {
            this.lcd.setText(req.getText());
        }
    }
}

