/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.tardis.babel.iot.controlprotocols;

import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.exception.Pi4JException;
import com.pi4j.library.pigpio.PiGpio;
import com.pi4j.platform.Platform;
import com.pi4j.plugin.linuxfs.provider.i2c.LinuxFsI2CProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalInputProvider;
import com.pi4j.plugin.pigpio.provider.gpio.digital.PiGpioDigitalOutputProvider;
import com.pi4j.plugin.pigpio.provider.pwm.PiGpioPwmProvider;
import com.pi4j.plugin.pigpio.provider.serial.PiGpioSerialProvider;
import com.pi4j.plugin.pigpio.provider.spi.PiGpioSpiProvider;
import com.pi4j.plugin.raspberrypi.platform.RaspberryPiPlatform;
import com.pi4j.provider.Provider;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.protocols.dissemination.notifications.IdentifiableMessageNotification;
import pt.unl.fct.di.novasys.babel.protocols.general.notifications.ChannelAvailableNotification;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveGestureDetector;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLcd;
import pt.unl.fct.di.novasys.iot.device.i2c.GroveLedMatrix;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.SetDisplayColorRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowAnimationRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowEmojiRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowGestureRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests.ShowTextRequest;
import pt.unl.fct.di.tardis.babel.iot.controlprotocols.utils.I2CScanner;

public class IoTControlProtocolV2
extends GenericProtocol {
    private static final Logger logger = LogManager.getLogger(IoTControlProtocolV2.class);
    public static final short PROTO_ID = 8000;
    public static final String PROTO_NAME = "IoTControlProtocolV2";
    public static final String IOT_POLLING_RATE = "iot.polling.rate";
    public static final String IOT_DEFAULT_POLLING_RATE = "1000";
    private final Context pi4j;
    private GroveLedMatrix matrix;
    private GroveLcd lcd;
    private byte[] lastState;
    private byte[] colors = new byte[]{82, 0, 127, -61, 24, -36, -86, 18, -2};
    private int currentX;
    private int currentY;
    private int maxCoordinate;
    private long thread_id;
    private int polling_rate;
    private I2CScanner scanner;

    public IoTControlProtocolV2() throws HandlerRegistrationException {
        super(PROTO_NAME, (short)8000);
        PiGpio piGpio = PiGpio.newNativeInstance();
        this.pi4j = (Context)Pi4J.newContextBuilder().noAutoDetect().add(new Platform[]{new RaspberryPiPlatform(this){

            protected String[] getProviders() {
                return new String[0];
            }
        }}).add(new Provider[]{PiGpioDigitalInputProvider.newInstance((PiGpio)piGpio), PiGpioDigitalOutputProvider.newInstance((PiGpio)piGpio), PiGpioPwmProvider.newInstance((PiGpio)piGpio), PiGpioSerialProvider.newInstance((PiGpio)piGpio), PiGpioSpiProvider.newInstance((PiGpio)piGpio), LinuxFsI2CProvider.newInstance()}).build();
        this.scanner = I2CScanner.getInstance();
        try {
            this.matrix = new GroveLedMatrix(this.pi4j);
        }
        catch (IOException e) {
            logger.error("Could not initialize the LedMatrix: ", (Throwable)e);
            this.matrix = null;
        }
        catch (Pi4JException pe) {
            logger.error("Could not initialize the LedMatrix: ", (Throwable)pe);
            this.matrix = null;
        }
        try {
            this.lcd = new GroveLcd(this.pi4j);
        }
        catch (IOException e) {
            logger.error("Could not initialize the LCD: ", (Throwable)e);
            this.lcd = null;
        }
        catch (Pi4JException pe) {
            logger.error("Could not initialize the LCD: ", (Throwable)pe);
            this.lcd = null;
        }
        if (this.matrix != null) {
            this.matrix.clearDisplay();
            this.lastState = this.matrix.getSnapshot();
            this.matrix.setAllColor((byte)-1, (byte)0, (byte)0);
            this.registerMatrixMethods();
        }
        if (this.lcd != null) {
            this.registerLCDMethods();
        }
        this.currentX = 0;
        this.currentY = 0;
        this.maxCoordinate = 8;
        this.thread_id = 0L;
    }

    public void init(Properties props) throws HandlerRegistrationException, IOException {
        String polling_rate_str = props.getProperty(IOT_POLLING_RATE, IOT_DEFAULT_POLLING_RATE);
        this.polling_rate = Integer.parseInt(polling_rate_str);
        Thread listener_thread = new Thread(this::deviceListener);
        this.thread_id = listener_thread.threadId();
        listener_thread.start();
    }

    private void deviceListener() {
        try {
            while (true) {
                this.scanner.detectDeviceActivity();
                Thread.sleep(this.polling_rate);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return;
        }
    }

    private void registerMatrixMethods() throws HandlerRegistrationException {
        this.registerRequestHandler((short)8003, this::handleShowAnimationRequest);
        this.registerRequestHandler((short)8005, this::handleShowGestureRequest);
        this.registerRequestHandler((short)8002, this::handleShowEmojiRequest);
        this.registerRequestHandler((short)8004, this::handleSetDisplayRequest);
        this.subscribeNotification((short)1, this::handleChannelAvailableNotificaiton);
        this.subscribeNotification((short)502, this::handleIdentifiableMessageNotification);
    }

    private void registerLCDMethods() throws HandlerRegistrationException {
        this.registerRequestHandler((short)8001, this::handleShowTextRequest);
    }

    private void handleShowAnimationRequest(ShowAnimationRequest req, short protoId) {
        this.matrix.displayColorAnimation(req.getAnimation());
    }

    private void handleShowEmojiRequest(ShowEmojiRequest req, short protoId) {
        this.matrix.displayEmoji(req.getEmoji());
    }

    private void handleShowGestureRequest(ShowGestureRequest req, short protoId) {
        GroveGestureDetector.PAJ7620GestureType gesture = req.getGesture();
        switch (gesture) {
            case UP: {
                System.out.println("up");
                this.matrix.setAllColor((byte)-1, (byte)0, (byte)0);
                break;
            }
            case DOWN: {
                System.out.println("down");
                this.matrix.setAllColor((byte)0, (byte)-1, (byte)0);
                break;
            }
            case LEFT: {
                System.out.println("left");
                this.matrix.setAllColor((byte)0, (byte)0, (byte)-1);
                break;
            }
            case RIGHT: {
                System.out.println("right");
                this.matrix.setAllColor((byte)-1, (byte)0, (byte)-1);
                break;
            }
            case PUSH: {
                System.out.println("push");
                this.matrix.setAllColor((byte)-1, (byte)-1, (byte)0);
                break;
            }
            case PULL: {
                System.out.println("pull");
                this.matrix.setAllColor((byte)0, (byte)-1, (byte)-1);
                break;
            }
        }
    }

    private void handleShowTextRequest(ShowTextRequest req, short protoId) {
        this.lcd.setText(req.getText());
    }

    private void handleChannelAvailableNotificaiton(ChannelAvailableNotification not, short protoId) {
        this.matrix.setAllColor((byte)0, (byte)-1, (byte)0);
    }

    private void handleSetDisplayRequest(SetDisplayColorRequest req, short protoId) {
        this.matrix.setAllColor((byte)req.getRed(), (byte)req.getGreen(), (byte)req.getBlue());
    }

    private void handleIdentifiableMessageNotification(IdentifiableMessageNotification not, short portoId) {
        int color = Math.abs(((int)(not.getMessage().getMID().getMostSignificantBits() % 16000L) + (int)(not.getMessage().getMID().getLeastSignificantBits() % 16000L)) % this.colors.length);
        this.matrix.loadSnapshot(this.lastState);
        try {
            this.matrix.setPixelColor(this.currentX, this.currentY, this.colors[color]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.currentY;
        if (this.currentY == this.maxCoordinate) {
            this.currentY = 0;
            ++this.currentX;
            if (this.currentX == this.maxCoordinate) {
                this.currentX = 0;
            }
        }
        this.lastState = this.matrix.getSnapshot();
    }
}

