package pt.unl.fct.di.tardis.babel.iot.controlprotocols;

import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.tardis.babel.iot.api.requests.IoTMeasurementRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.IoTPeriodicMeasurementRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.IoTReactiveMeasurementRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.RegisterIoTDeviceRequest;
import pt.unl.fct.di.tardis.babel.iot.api.requests.UnregisterIoTDeviceRequest;

public class I2CInputControlProtocol extends GenericProtocol {

    public final static String PROTOCOL_NAME = "I2CInputControlProtocol";
    public final static short PROTOCOL_ID = 4001;

    private static final Logger logger =
        LogManager.getLogger(I2CInputControlProtocol.class);

    public I2CInputControlProtocol() { super(PROTOCOL_NAME, PROTOCOL_ID); }

    @Override
    public void init(Properties props)
        throws HandlerRegistrationException, IOException {
        registerRequestHandler(RegisterIoTDeviceRequest.REQUEST_ID,
                               this::handleRegisterIoTDeviceRequest);
        registerRequestHandler(UnregisterIoTDeviceRequest.REQUEST_ID,
                               this::handleUnregisterIoTDeviceRequest);
        registerRequestHandler(IoTMeasurementRequest.REQUEST_ID,
                               this::handleIoTMeasurementRequest);
        registerRequestHandler(IoTReactiveMeasurementRequest.REQUEST_ID,
                               this::handleIoTReactiveMeasurementRequest);
        registerRequestHandler(IoTPeriodicMeasurementRequest.REQUEST_ID,
                               this::handleIoTPeriodicMeasurementRequest);
    }

    /*******************************************************************************
     * handles for Protoocol Requests
     ******************************************************************************/

    public void handleRegisterIoTDeviceRequest(RegisterIoTDeviceRequest req,
                                               short protocolId) {}

    public void handleUnregisterIoTDeviceRequest(UnregisterIoTDeviceRequest req,
                                                 short protocolId) {}

    public void handleIoTMeasurementRequest(IoTMeasurementRequest req,
                                            short protocolId) {}

    public void
    handleIoTPeriodicMeasurementRequest(IoTPeriodicMeasurementRequest req,
                                        short protocolId) {}

    public void
    handleIoTReactiveMeasurementRequest(IoTReactiveMeasurementRequest<?> req,
                                        short protocolId) {}
}
