package pt.unl.fct.di.tardis.babel.iot.controlprotocols.requests;

import pt.unl.fct.di.tardis.babel.iot.api.DeviceHandle;
import pt.unl.fct.di.tardis.babel.iot.api.requests.IoTOutputRequest;

public class ShowDisplayRequest extends IoTOutputRequest {

    public static final short REQUEST_ID = 8006;

    private final byte[] displayMap;

    public ShowDisplayRequest(DeviceHandle h, byte[] displayMap) {
        super(ShowDisplayRequest.REQUEST_ID, h);
        this.displayMap = displayMap;
    }

    public byte[] getDisplay() { return this.displayMap; }
}
