/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.overlayEstimations.RandomTour;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.OverlaySize;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoNotification;
import pt.unl.fct.di.novasys.babel.protocols.general.notifications.ChannelAvailableNotification;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.RandomTour.messages.RandomTourMessage;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.RandomTour.timers.RandomTourTimer;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class RandomTour
extends GenericProtocol {
    private static final Logger logger = LogManager.getLogger(RandomTour.class);
    public static final short PROTOCOL_ID = 2398;
    public static final String PROTOCOL_NAME = "RandomTour";
    public static final String PAR_CHANNEL_ADDRESS = "RandomTour.Channel.Address";
    public static final String PAR_CHANNEL_PORT = "RandomTour.Channel.Port";
    public static final String PAR_ESTIMATION_TIMEOUT = "RandomTour.EstimationTimeout";
    public static final String PAR_NUMBER_OF_RUNS = "RandomTour.NumberOfRuns";
    public int networkPort;
    protected int channelId;
    protected Host myself;
    private boolean managingChannel;
    private final int estimationTimeout;
    private final Random random;
    private Set<Host> pending;
    private Set<Host> connectedNeighbors;
    private final CircularFifoQueue<Integer> estimations;

    public RandomTour(Properties properties, Host myself) throws HandlerRegistrationException, IOException {
        super(PROTOCOL_NAME, (short)2398);
        this.myself = myself;
        this.estimationTimeout = Integer.parseInt(properties.getProperty(PAR_ESTIMATION_TIMEOUT, "300000"));
        this.pending = new HashSet<Host>();
        this.connectedNeighbors = new HashSet<Host>();
        int numberOfRuns = Integer.parseInt(properties.getProperty(PAR_NUMBER_OF_RUNS, "10"));
        this.estimations = new CircularFifoQueue(numberOfRuns);
        this.random = new Random();
        String address = null;
        Object port = null;
        if (properties.containsKey(PAR_CHANNEL_ADDRESS) && properties.containsKey(PAR_CHANNEL_PORT)) {
            address = properties.getProperty(PAR_CHANNEL_ADDRESS);
            port = properties.getProperty(PAR_CHANNEL_PORT);
            this.networkPort = Short.parseShort((String)port);
            if (this.myself == null) {
                this.myself = new Host(InetAddress.getByName(address), this.networkPort);
            }
        } else if (this.myself != null) {
            address = myself.getAddress().getHostAddress();
            this.networkPort = myself.getPort();
            port = "" + this.networkPort;
        }
        this.channelId = -1;
        if (address != null && port != null) {
            this.managingChannel = true;
            Properties channelProps = new Properties();
            channelProps.setProperty("address", address);
            channelProps.setProperty("port", (String)port);
            this.channelId = this.createChannel("TCPChannel", channelProps);
            this.setDefaultChannel(this.channelId);
            this.subscribeNotifitcations();
            this.registerChannelEvents();
            this.registerMessages();
        } else {
            this.managingChannel = false;
            this.subscribeNotification((short)1, this::uponChannelAvailableNotifiction);
        }
        this.registerTimerHandler((short)2401, this::uponRandomTourTimer);
    }

    public void init(Properties props) {
        logger.debug("Starting RandomTour protocol within {} seconds", (Object)(this.estimationTimeout / 1000));
        this.setupPeriodicTimer(RandomTourTimer.getInstance(), this.estimationTimeout, this.estimationTimeout);
    }

    private void uponRandomTourMessageFailedSend(RandomTourMessage message, Host from, short sourceProto, int channelId) {
    }

    private void uponRandomTourMessage(RandomTourMessage message, Host from, short sourceProto, int channelId) {
        logger.debug("Received RandomTourMessage from {}", (Object)from);
        if (!message.getSource().equals((Object)this.myself)) {
            logger.debug("Set counter to {}", (Object)message.getCounter());
            HashSet<Host> destinations = new HashSet<Host>(this.connectedNeighbors);
            destinations.remove(from);
            Host dest = from;
            if (destinations.size() > 0) {
                dest = destinations.toArray(new Host[destinations.size()])[this.random.nextInt(destinations.size())];
            }
            this.sendMessage(message.incrementCounter(this.connectedNeighbors.size()), dest);
        } else {
            logger.debug("Message returned to source");
            double estimation = message.getCounter() * (double)this.connectedNeighbors.size();
            logger.debug("Estimation: {}", (Object)estimation);
            this.estimations.add((Object)((int)estimation));
            if (this.estimations.isAtFullCapacity()) {
                double average = 0.0;
                Iterator iterator = this.estimations.iterator();
                while (iterator.hasNext()) {
                    int est = (Integer)iterator.next();
                    average += (double)est;
                }
                logger.trace("Average overlay size: {}", (Object)(average /= (double)this.estimations.size()));
                this.triggerNotification((ProtoNotification)new OverlaySize(this.myself, Math.round(average)));
            } else {
                logger.debug("Waiting for more estimations. Only got {} out of {} required.", (Object)this.estimations.size(), (Object)this.estimations.maxSize());
            }
        }
    }

    private void uponNeighborUp(NeighborUp up, short protoID) {
        Host h = new Host(up.getPeer().getAddress(), this.networkPort);
        if (this.managingChannel) {
            if (!this.connectedNeighbors.contains(h) && this.pending.add(h)) {
                this.openConnection(h);
            }
        } else {
            this.connectedNeighbors.add(h);
        }
    }

    private void uponNeighborDown(NeighborDown down, short protoID) {
        Host h = new Host(down.getPeer().getAddress(), this.networkPort);
        if (this.managingChannel) {
            if (this.connectedNeighbors.remove(h)) {
                this.closeConnection(h);
            } else if (this.pending.remove(h)) {
                this.closeConnection(h);
            }
        } else {
            this.connectedNeighbors.remove(h);
        }
    }

    private void uponChannelAvailableNotifiction(ChannelAvailableNotification event, short protoID) {
        if (this.channelId == -1) {
            logger.debug("A channel became available from protocol {}", (Object)event.getProtoSourceName());
            this.myself = event.getChannelListenData();
            this.networkPort = this.myself.getPort();
            this.channelId = event.getChannelID();
            this.registerSharedChannel(this.channelId);
            try {
                this.subscribeNotifitcations();
                this.registerChannelEvents();
                this.registerMessages();
            }
            catch (HandlerRegistrationException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            this.unsubscribeNotification((short)1);
        }
    }

    private void uponRandomTourTimer(RandomTourTimer timer, long timerId) {
        logger.debug("Starting RandomTour phase");
        if (this.connectedNeighbors.size() > 0) {
            Host next = (Host)this.connectedNeighbors.stream().skip(this.random.nextInt(this.connectedNeighbors.size())).findFirst().get();
            RandomTourMessage message = new RandomTourMessage(this.myself, 1.0);
            this.sendMessage(message, next);
        }
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        Host h = event.getNode();
        logger.trace("Host {} is down, cause: {}", (Object)h, (Object)event.getCause());
        if (this.connectedNeighbors.contains(h) || this.pending.contains(h)) {
            this.connectedNeighbors.remove(h);
            this.pending.add(h);
            this.openConnection(h);
        }
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        Host h = event.getNode();
        logger.trace("Connection to host {} failed, cause: {}", (Object)h, (Object)event.getCause());
        if (this.connectedNeighbors.contains(h) || this.pending.contains(h)) {
            this.connectedNeighbors.remove(h);
            this.pending.add(h);
            this.openConnection(h);
        }
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        Host h = event.getNode();
        logger.trace("Host (out) {} is up", (Object)h);
        if (!this.connectedNeighbors.contains(h) && !this.pending.contains(h)) {
            this.closeConnection(h);
            return;
        }
        this.pending.remove(h);
        this.connectedNeighbors.add(h);
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        logger.trace("Connection from host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void registerMessages() throws HandlerRegistrationException {
        this.registerMessageHandler(this.channelId, (short)2399, this::uponRandomTourMessage, this::uponRandomTourMessageFailedSend);
        this.registerMessageSerializer(this.channelId, (short)2399, RandomTourMessage.serializer);
    }

    private void subscribeNotifitcations() throws HandlerRegistrationException {
        this.subscribeNotification((short)401, this::uponNeighborUp);
        this.subscribeNotification((short)402, this::uponNeighborDown);
    }

    private void registerChannelEvents() throws HandlerRegistrationException {
        this.registerChannelEventHandler(this.channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(this.channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)1, this::uponInConnectionDown);
    }
}

