/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.overlayEstimations.RandomTour.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class RandomTourMessage
extends ProtoMessage {
    public static final short MSG_CODE = 2399;
    private final Host source;
    private double counter;
    public static final ISerializer<RandomTourMessage> serializer = new ISerializer<RandomTourMessage>(){

        public void serialize(RandomTourMessage m, ByteBuf out) throws IOException {
            Host.serializer.serialize((Object)m.getSource(), out);
            out.writeDouble(m.getCounter());
        }

        public RandomTourMessage deserialize(ByteBuf in) throws IOException {
            Host source = (Host)Host.serializer.deserialize(in);
            double counter = in.readDouble();
            return new RandomTourMessage(source, counter);
        }
    };

    public RandomTourMessage(Host source, double counter) {
        super((short)2399);
        this.source = source;
        this.counter = counter;
    }

    public Host getSource() {
        return this.source;
    }

    public double getCounter() {
        return this.counter;
    }

    public RandomTourMessage incrementCounter(int d) {
        this.counter += 1.0 / (double)d;
        this.counter += 1.0;
        return this;
    }

    public void setCounter(double counter) {
        this.counter = counter;
    }

    public String toString() {
        return "scPeerSamplingMessage{source=" + String.valueOf(this.source) + ", counter=" + this.counter + "}";
    }
}

