/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.overlayEstimations.RandomTour.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class RandomTourMessage
extends ProtoMessage {
    public static final short MSG_CODE = 2399;
    private final Host source;
    private Host lastHop;
    private double counter;
    public static final ISerializer<RandomTourMessage> serializer = new ISerializer<RandomTourMessage>(){

        public void serialize(RandomTourMessage m, ByteBuf out) throws IOException {
            Host.serializer.serialize((Object)m.getSource(), out);
            Host.serializer.serialize((Object)m.getLastHop(), out);
            out.writeDouble(m.getCounter());
        }

        public RandomTourMessage deserialize(ByteBuf in) throws IOException {
            Host source = (Host)Host.serializer.deserialize(in);
            Host lastHop = (Host)Host.serializer.deserialize(in);
            double counter = in.readDouble();
            return new RandomTourMessage(source, lastHop, counter);
        }
    };

    public RandomTourMessage(Host source, Host lastHop, double counter) {
        super((short)2399);
        this.source = source;
        this.lastHop = lastHop;
        this.counter = counter;
    }

    public RandomTourMessage(Host source, double counter) {
        super((short)2399);
        this.source = source;
        this.lastHop = source;
        this.counter = counter;
    }

    public Host getSource() {
        return this.source;
    }

    public Host getLastHop() {
        return this.lastHop;
    }

    public double getCounter() {
        return this.counter;
    }

    public RandomTourMessage updateMessage(int d) {
        this.counter += 1.0 / (double)d;
        return this;
    }

    public RandomTourMessage updateMessage(Host h, int d) {
        this.lastHop = h;
        this.counter += 1.0 / (double)d;
        return this;
    }

    public void setCounter(double counter) {
        this.counter = counter;
    }

    public String toString() {
        return "scPeerSamplingMessage{source=" + String.valueOf(this.source) + "lastHop=" + String.valueOf(this.lastHop) + ", counter=" + this.counter + "}";
    }
}

