/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.memebership.monitor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.OverlaySize;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.ReconfigurationFailed;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.ReconfigurationSucceeded;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.GetAdaptiveFieldsReply;
import pt.unl.fct.di.novasys.babel.core.adaptive.requests.GetAdaptiveFieldsRequest;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoRequest;
import pt.unl.fct.di.novasys.babel.utils.memebership.monitor.timer.AdaptiveFieldsCheckTimer;

public class AdaptiveReconfigurationMonitor
extends GenericProtocol {
    private static final Logger logger = LogManager.getLogger(AdaptiveReconfigurationMonitor.class);
    public static final short PROTOCOL_ID = 1677;
    public static final String PROTOCOL_NAME = "Adaptive-Reconfiguration-Monitor";
    public static final String PAR_MEMBERSHIP_CHECK_PERIOD = "Monitor.period";
    public static final String PAR_ADAPTIVE_PROTO_IDS = "Monitor.adaptive.ids";
    private Short[] adaptiveProtocolIDs;

    public AdaptiveReconfigurationMonitor() throws HandlerRegistrationException {
        super(PROTOCOL_NAME, (short)1677);
        this.registerTimerHandler((short)16672, this::handleAdaptiveFieldsCheckTimer);
        this.subscribeNotification((short)701, this::handleOverlayNotification);
        this.subscribeNotification((short)700, this::handleReconfigFailedNotification);
        this.subscribeNotification((short)702, this::handleReconfigSucceededNotification);
        this.registerReplyHandler((short)706, this::handleGetAdaptiveFieldsReply);
    }

    public void init(Properties props) throws HandlerRegistrationException, IOException {
        String[] idStrings = props.getProperty(PAR_ADAPTIVE_PROTO_IDS, "").split(",");
        this.adaptiveProtocolIDs = (Short[])Arrays.stream(idStrings).map(Short::parseShort).toArray(Short[]::new);
        long period = Long.parseLong(props.getProperty(PAR_MEMBERSHIP_CHECK_PERIOD, "0"));
        if (period > 0L) {
            Short[] shortArray = this.adaptiveProtocolIDs;
            int n = shortArray.length;
            for (int i = 0; i < n; ++i) {
                short id = shortArray[i];
                this.setupPeriodicTimer(new AdaptiveFieldsCheckTimer(id), period, period);
            }
        }
    }

    private void handleAdaptiveFieldsCheckTimer(AdaptiveFieldsCheckTimer t, long time) {
        logger.debug("Requesting adaptive fields from protocol with id: " + t.getProtocolID());
        this.sendRequest((ProtoRequest)new GetAdaptiveFieldsRequest(), t.getProtocolID());
    }

    private void handleOverlayNotification(OverlaySize n, short proto) {
        logger.info((Object)n);
    }

    private void handleReconfigFailedNotification(ReconfigurationFailed n, short proto) {
        logger.info((Object)n);
    }

    private void handleReconfigSucceededNotification(ReconfigurationSucceeded n, short proto) {
        logger.info((Object)n);
    }

    private void handleGetAdaptiveFieldsReply(GetAdaptiveFieldsReply r, short proto) {
        logger.info("Received adaptive fields from protocol {}: {}", (Object)proto, (Object)r.getFields());
    }
}

