/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.OverlaySize;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoNotification;
import pt.unl.fct.di.novasys.babel.protocols.general.notifications.ChannelAvailableNotification;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide.messages.SCPeerSamplingMessage;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide.messages.SCPeerSamplingMessageReply;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide.timers.ContinuousTimeRandomWalkTimer;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class SampleAndCollide
extends GenericProtocol {
    private static final Logger logger = LogManager.getLogger(SampleAndCollide.class);
    public static final short PROTOCOL_ID = 2398;
    public static final String PROTOCOL_NAME = "SampleAndCollide";
    public static final String PAR_CHANNEL_ADDRESS = "SampleAndCollide.Channel.Address";
    public static final String PAR_CHANNEL_PORT = "SampleAndCollide.Channel.Port";
    public static final String PAR_TARGET_COLLISIONS = "SampleAndCollide.TargetCollisions";
    public static final String PAR_INITIAL_WALK_TIME = "SampleAndCollide.InitialWalkTime";
    public static final String PAR_ESTIMATION_TIMEOUT = "SampleAndCollide.EstimationTimeout";
    public static final String PAR_NUMBER_OF_RUNS = "SampleAndCollide.NumberOfRuns";
    public int networkPort;
    protected int channelId;
    protected Host myself;
    private boolean managingChannel;
    private final int targetCollisions;
    private int currentCollisions;
    private final int initialWalkTime;
    private final int estimationTimeout;
    private final CircularFifoQueue<Integer> estimations;
    private final Random random;
    private Set<Host> pending;
    private Set<Host> connectedNeighbors;
    private Set<Host> samples;

    public SampleAndCollide(Properties properties, Host myself) throws HandlerRegistrationException, IOException {
        super(PROTOCOL_NAME, (short)2398);
        this.myself = myself;
        this.targetCollisions = Integer.parseInt(properties.getProperty(PAR_TARGET_COLLISIONS, "100"));
        this.initialWalkTime = Integer.parseInt(properties.getProperty(PAR_INITIAL_WALK_TIME, "10"));
        this.estimationTimeout = Integer.parseInt(properties.getProperty(PAR_ESTIMATION_TIMEOUT, "20000"));
        int numberOfRuns = Integer.parseInt(properties.getProperty(PAR_NUMBER_OF_RUNS, "10"));
        this.pending = new HashSet<Host>();
        this.connectedNeighbors = new HashSet<Host>();
        this.samples = new LinkedHashSet<Host>();
        this.estimations = new CircularFifoQueue(numberOfRuns);
        this.random = new Random();
        this.currentCollisions = 0;
        String address = null;
        Object port = null;
        if (properties.containsKey(PAR_CHANNEL_ADDRESS) && properties.containsKey(PAR_CHANNEL_PORT)) {
            address = properties.getProperty(PAR_CHANNEL_ADDRESS);
            port = properties.getProperty(PAR_CHANNEL_PORT);
            this.networkPort = Short.parseShort((String)port);
            if (this.myself == null) {
                this.myself = new Host(InetAddress.getByName(address), this.networkPort);
            }
        } else if (this.myself != null) {
            address = myself.getAddress().getHostAddress();
            this.networkPort = myself.getPort() + 2;
            port = "" + this.networkPort;
        }
        this.channelId = -1;
        if (address != null && port != null) {
            this.managingChannel = true;
            Properties channelProps = new Properties();
            channelProps.setProperty("address", address);
            channelProps.setProperty("port", (String)port);
            this.channelId = this.createChannel("TCPChannel", channelProps);
            this.setDefaultChannel(this.channelId);
            this.subscribeNotifitcations();
            this.registerChannelEvents();
            this.registerMessageHandlers();
        } else {
            this.managingChannel = false;
            this.subscribeNotification((short)1, this::uponChannelAvailableNotifiction);
        }
        this.registerTimerHandler((short)2401, this::uponContinuousTimeRandomWalkTimer);
    }

    public void init(Properties props) {
        logger.debug("Starting SampleAndCollide protocol within {} seconds", (Object)(this.estimationTimeout / 1000));
        this.setupTimer(ContinuousTimeRandomWalkTimer.getInstance(), this.estimationTimeout);
    }

    private void uponPeerSamplingMessage(SCPeerSamplingMessage message, Host from, short sourceProto, int channelId) {
        logger.debug("Received PeerSamplingMessage from {}", (Object)from);
        int newWalkTime = this.decreaseWalkTime(message.getWalkTime(), message.getInitiatorDegree());
        if (newWalkTime <= 0) {
            logger.debug("I am the sample");
            this.sendMessage(new SCPeerSamplingMessageReply(this.myself), from);
            return;
        }
        message.setWalkTime(newWalkTime);
        Host next = (Host)this.connectedNeighbors.stream().skip(this.random.nextInt(this.connectedNeighbors.size())).findFirst().get();
        this.sendMessage(message, next);
        logger.trace("Forwarding PeerSamplingMessage {} to {}", (Object)message, (Object)next);
    }

    private void uponPeerSamplingMessageReply(SCPeerSamplingMessageReply message, Host from, short sourceProto, int channelId) {
        logger.debug("Received PeerSamplingReply from {}", (Object)from);
        if (this.samples.add(message.getSample())) {
            return;
        }
        if (++this.currentCollisions < this.targetCollisions) {
            return;
        }
        int lastCollision = this.samples.size() + this.currentCollisions;
        int lowerBound = (lastCollision - this.targetCollisions - 1) * (lastCollision - this.targetCollisions) / (2 * this.targetCollisions);
        int upperBound = lowerBound + lastCollision - this.targetCollisions - 1;
        int estimate = (lowerBound + upperBound) / 2;
        while (upperBound - lowerBound > 1) {
            int sum = 0;
            for (int i = 0; i < lastCollision - this.targetCollisions - 1; ++i) {
                sum += i / estimate - i - this.targetCollisions;
            }
            if (sum > 0) {
                lowerBound = estimate;
                continue;
            }
            upperBound = estimate;
        }
        logger.debug("Storing new estimation: {}", (Object)estimate);
        this.estimations.add((Object)estimate);
        logger.debug("Current estimations: {}", this.estimations);
        int average = 0;
        Iterator iterator = this.estimations.iterator();
        while (iterator.hasNext()) {
            int est = (Integer)iterator.next();
            average += est;
        }
        this.triggerNotification((ProtoNotification)new OverlaySize((long)(average /= this.estimations.size())));
        this.currentCollisions = 0;
        this.samples.clear();
        this.setupTimer(ContinuousTimeRandomWalkTimer.getInstance(), this.estimationTimeout);
    }

    private int decreaseWalkTime(int walkTime, int initiatorDegree) {
        return (int)((double)walkTime - Math.log10(1.0 / this.random.nextDouble()) / (double)initiatorDegree);
    }

    private void uponNeighborUp(NeighborUp up, short protoID) {
        Host h = new Host(up.getPeer().getAddress(), this.networkPort);
        if (this.managingChannel) {
            if (!this.connectedNeighbors.contains(h) && this.pending.add(h)) {
                this.openConnection(h);
            }
        } else {
            this.connectedNeighbors.add(h);
        }
    }

    private void uponNeighborDown(NeighborDown down, short protoID) {
        Host h = new Host(down.getPeer().getAddress(), this.networkPort);
        if (this.managingChannel) {
            if (this.connectedNeighbors.remove(h)) {
                this.closeConnection(h);
            } else if (this.pending.remove(h)) {
                this.closeConnection(h);
            }
        } else {
            this.connectedNeighbors.remove(h);
        }
    }

    private void uponChannelAvailableNotifiction(ChannelAvailableNotification event, short protoID) {
        if (this.channelId == -1) {
            this.myself = event.getChannelListenData();
            this.networkPort = this.myself.getPort();
            this.channelId = event.getChannelID();
            this.registerSharedChannel(this.channelId);
            try {
                this.subscribeNotifitcations();
                this.registerChannelEvents();
                this.registerMessageHandlers();
            }
            catch (HandlerRegistrationException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            this.unsubscribeNotification((short)1);
        }
    }

    private void uponContinuousTimeRandomWalkTimer(ContinuousTimeRandomWalkTimer timer, long time) {
        if (this.connectedNeighbors.isEmpty()) {
            return;
        }
        Host next = (Host)this.connectedNeighbors.stream().skip(this.random.nextInt(this.connectedNeighbors.size())).findFirst().get();
        logger.debug("Starting Continuous Time Random Walk to {}", (Object)next);
        this.sendMessage(new SCPeerSamplingMessage(this.myself, this.initialWalkTime, this.connectedNeighbors.size()), next);
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        Host h = event.getNode();
        logger.trace("Host {} is down, cause: {}", (Object)h, (Object)event.getCause());
        if (this.connectedNeighbors.contains(h) || this.pending.contains(h)) {
            this.connectedNeighbors.remove(h);
            this.pending.add(h);
            this.openConnection(h);
        }
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        Host h = event.getNode();
        logger.trace("Connection to host {} failed, cause: {}", (Object)h, (Object)event.getCause());
        if (this.connectedNeighbors.contains(h) || this.pending.contains(h)) {
            this.connectedNeighbors.remove(h);
            this.pending.add(h);
            this.openConnection(h);
        }
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        Host h = event.getNode();
        logger.trace("Host (out) {} is up", (Object)h);
        if (!this.connectedNeighbors.contains(h) && !this.pending.contains(h)) {
            this.closeConnection(h);
        }
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        logger.trace("Connection from host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void registerMessageHandlers() throws HandlerRegistrationException {
        this.registerMessageHandler(this.channelId, (short)2399, this::uponPeerSamplingMessage);
        this.registerMessageHandler(this.channelId, (short)2400, this::uponPeerSamplingMessageReply);
    }

    private void subscribeNotifitcations() throws HandlerRegistrationException {
        this.subscribeNotification((short)401, this::uponNeighborUp);
        this.subscribeNotification((short)402, this::uponNeighborDown);
    }

    private void registerChannelEvents() throws HandlerRegistrationException {
        this.registerChannelEventHandler(this.channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(this.channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)1, this::uponInConnectionDown);
    }
}

