/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class SCPeerSamplingMessage
extends ProtoMessage {
    public static final short MSG_CODE = 2399;
    private final Host source;
    private int walkTime;
    private final int initiatorDegree;
    public static final ISerializer<SCPeerSamplingMessage> serializer = new ISerializer<SCPeerSamplingMessage>(){

        public void serialize(SCPeerSamplingMessage m, ByteBuf out) throws IOException {
            Host.serializer.serialize((Object)m.getSource(), out);
            out.writeInt(m.getWalkTime());
            out.writeInt(m.getInitiatorDegree());
        }

        public SCPeerSamplingMessage deserialize(ByteBuf in) throws IOException {
            Host source = (Host)Host.serializer.deserialize(in);
            int walkTime = in.readInt();
            int initiatorDegree = in.readInt();
            return new SCPeerSamplingMessage(source, walkTime, initiatorDegree);
        }
    };

    public SCPeerSamplingMessage(Host source, int walkTime, int initiatorDegree) {
        super((short)2399);
        this.source = source;
        this.walkTime = walkTime;
        this.initiatorDegree = initiatorDegree;
    }

    public Host getSource() {
        return this.source;
    }

    public int getWalkTime() {
        return this.walkTime;
    }

    public int getInitiatorDegree() {
        return this.initiatorDegree;
    }

    public void setWalkTime(int walkTime) {
        this.walkTime = walkTime;
    }

    public String toString() {
        return "scPeerSamplingMessage{source=" + String.valueOf(this.source) + ", walkTime=" + this.walkTime + ", initiatorDegree=" + this.initiatorDegree + "}";
    }
}

