/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.core.adaptive.notifications.OverlaySize;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.generic.ProtoNotification;
import pt.unl.fct.di.novasys.babel.protocols.general.notifications.ChannelAvailableNotification;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide.messages.SCPeerSamplingMessage;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide.messages.SCPeerSamplingMessageReply;
import pt.unl.fct.di.novasys.babel.utils.overlayEstimations.SampleAndCollide.timers.ContinuousTimeRandomWalkTimer;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class SampleAndCollide
extends GenericProtocol {
    private static final Logger logger = LogManager.getLogger(SampleAndCollide.class);
    public static final short PROTOCOL_ID = 2398;
    public static final String PROTOCOL_NAME = "SampleAndCollide";
    public static final String PAR_CHANNEL_ADDRESS = "SampleAndCollide.Channel.Address";
    public static final String PAR_CHANNEL_PORT = "SampleAndCollide.Channel.Port";
    public static final String PAR_TARGET_COLLISIONS = "SampleAndCollide.TargetCollisions";
    public static final String PAR_INITIAL_WALK_TIME = "SampleAndCollide.InitialWalkTime";
    public static final String PAR_ESTIMATION_TIMEOUT = "SampleAndCollide.EstimationTimeout";
    public static final String PAR_NUMBER_OF_RUNS = "SampleAndCollide.NumberOfRuns";
    public int networkPort;
    protected int channelId;
    protected Host myself;
    private boolean managingChannel;
    private final int targetCollisions;
    private final int initialWalkTime;
    private final int estimationTimeout;
    private int replyCounter;
    private final CircularFifoQueue<Integer> estimations;
    private final Random random;
    private Set<Host> pending;
    private Set<Host> connectedNeighbors;
    private Map<Host, Integer> samples;

    public SampleAndCollide(Properties properties, Host myself) throws HandlerRegistrationException, IOException {
        super(PROTOCOL_NAME, (short)2398);
        this.myself = myself;
        this.targetCollisions = Integer.parseInt(properties.getProperty(PAR_TARGET_COLLISIONS, "100"));
        this.initialWalkTime = Integer.parseInt(properties.getProperty(PAR_INITIAL_WALK_TIME, "10"));
        this.estimationTimeout = Integer.parseInt(properties.getProperty(PAR_ESTIMATION_TIMEOUT, "10000"));
        int numberOfRuns = Integer.parseInt(properties.getProperty(PAR_NUMBER_OF_RUNS, "10"));
        this.pending = new HashSet<Host>();
        this.connectedNeighbors = new HashSet<Host>();
        this.samples = new HashMap<Host, Integer>();
        this.estimations = new CircularFifoQueue(numberOfRuns);
        this.replyCounter = 0;
        this.random = new Random();
        String address = null;
        Object port = null;
        if (properties.containsKey(PAR_CHANNEL_ADDRESS) && properties.containsKey(PAR_CHANNEL_PORT)) {
            address = properties.getProperty(PAR_CHANNEL_ADDRESS);
            port = properties.getProperty(PAR_CHANNEL_PORT);
            this.networkPort = Short.parseShort((String)port);
            if (this.myself == null) {
                this.myself = new Host(InetAddress.getByName(address), this.networkPort);
            }
        } else if (this.myself != null) {
            address = myself.getAddress().getHostAddress();
            this.networkPort = myself.getPort();
            port = "" + this.networkPort;
        }
        this.channelId = -1;
        if (address != null && port != null) {
            this.managingChannel = true;
            Properties channelProps = new Properties();
            channelProps.setProperty("address", address);
            channelProps.setProperty("port", (String)port);
            this.channelId = this.createChannel("TCPChannel", channelProps);
            this.setDefaultChannel(this.channelId);
            this.subscribeNotifitcations();
            this.registerChannelEvents();
            this.registerMessages();
        } else {
            this.managingChannel = false;
            this.subscribeNotification((short)1, this::uponChannelAvailableNotifiction);
        }
        this.registerTimerHandler((short)2401, this::uponContinuousTimeRandomWalkTimer);
    }

    public void init(Properties props) {
        logger.debug("Starting SampleAndCollide protocol within {} seconds", (Object)(this.estimationTimeout / 1000));
        this.setupPeriodicTimer(ContinuousTimeRandomWalkTimer.getInstance(), this.estimationTimeout, this.estimationTimeout);
    }

    private void uponPeerSamplingMessage(SCPeerSamplingMessage message, Host from, short sourceProto, int channelId) {
        double newWalkTime = this.decreaseWalkTime(message.getWalkTime());
        logger.trace("Received PeerSamplingMessage from {} with T = {} and calculated T' = {}", (Object)from, (Object)message.getWalkTime(), (Object)newWalkTime);
        if (newWalkTime <= 0.0) {
            logger.debug("I am the sample. Replying to {}", (Object)from);
            this.sendMessage(new SCPeerSamplingMessageReply(this.myself), from);
            return;
        }
        message.setWalkTime(newWalkTime);
        Host next = (Host)this.connectedNeighbors.stream().skip(this.random.nextInt(this.connectedNeighbors.size())).findFirst().get();
        this.sendMessage(message, next);
        logger.trace("Forwarding PeerSamplingMessage {} to {}", (Object)message, (Object)next);
    }

    private void uponPeerSamplingMessageReply(SCPeerSamplingMessageReply message, Host from, short sourceProto, int channelId) {
        logger.trace("Received PeerSamplingReply from {}", (Object)from);
        ++this.replyCounter;
        Host sample = message.getSample();
        Integer sampleCollisions = this.samples.get(sample);
        if (sampleCollisions == null) {
            logger.debug("New sample found: {}", (Object)sample);
            this.samples.put(sample, 0);
            logger.trace("Current samples: {}", this.samples.entrySet());
            return;
        }
        if ((sampleCollisions = Integer.valueOf(sampleCollisions + 1)) < this.targetCollisions) {
            logger.debug("Collision detected. Sample {} has {} collisions", (Object)sample, (Object)sampleCollisions);
            this.samples.put(sample, sampleCollisions);
            logger.trace("Current samples: {}", this.samples.entrySet());
            return;
        }
        if (this.samples.size() == 1) {
            return;
        }
        logger.debug("Target collisions reached. Estimating overlay size...");
        logger.trace("Current samples: {}", this.samples.entrySet());
        double delta = this.replyCounter - this.targetCollisions - 1;
        double lowerBound = delta * (double)(this.replyCounter - this.targetCollisions) / (double)(2 * this.targetCollisions);
        double upperBound = lowerBound + delta;
        double estimate = (lowerBound + upperBound) / 2.0;
        logger.debug("Starting bisection search with lower bound: {}, upper bound: {} and the last collision was {}", (Object)lowerBound, (Object)upperBound, (Object)this.replyCounter);
        while (upperBound - lowerBound > 1.0) {
            double sum = 0.0;
            int i = 0;
            while ((double)i < delta) {
                sum += (double)i / estimate - (double)i - (double)this.targetCollisions;
                ++i;
            }
            if (sum > 0.0) {
                lowerBound = estimate;
            } else {
                upperBound = estimate;
            }
            estimate = (lowerBound + upperBound) / 2.0;
        }
        logger.debug("Storing new estimation: {}", (Object)estimate);
        this.estimations.add((Object)((int)Math.round(estimate)));
        logger.debug("Current estimations: {}", this.estimations);
        if (this.estimations.isAtFullCapacity()) {
            double average = 0.0;
            Iterator iterator = this.estimations.iterator();
            while (iterator.hasNext()) {
                int est = (Integer)iterator.next();
                average += (double)est;
            }
            logger.trace("Average overlay size: {}", (Object)(average /= (double)this.estimations.size()));
            this.triggerNotification((ProtoNotification)new OverlaySize(this.myself, Math.round(average)));
        } else {
            logger.debug("Waiting for more estimations. Only got {} out of {} required.", (Object)this.estimations.size(), (Object)this.estimations.maxSize());
        }
        this.samples.clear();
        this.replyCounter = 0;
    }

    private double decreaseWalkTime(double walkTime) {
        return walkTime - Math.log10(1.0 / this.random.nextDouble()) / (double)this.connectedNeighbors.size();
    }

    private void uponNeighborUp(NeighborUp up, short protoID) {
        Host h = new Host(up.getPeer().getAddress(), this.networkPort);
        if (this.managingChannel) {
            if (!this.connectedNeighbors.contains(h) && this.pending.add(h)) {
                this.openConnection(h);
            }
        } else {
            this.connectedNeighbors.add(h);
        }
    }

    private void uponNeighborDown(NeighborDown down, short protoID) {
        Host h = new Host(down.getPeer().getAddress(), this.networkPort);
        if (this.managingChannel) {
            if (this.connectedNeighbors.remove(h)) {
                this.closeConnection(h);
            } else if (this.pending.remove(h)) {
                this.closeConnection(h);
            }
        } else {
            this.connectedNeighbors.remove(h);
        }
    }

    private void uponChannelAvailableNotifiction(ChannelAvailableNotification event, short protoID) {
        if (this.channelId == -1) {
            logger.debug("A channel became available from protocol {}", (Object)event.getProtoSourceName());
            this.myself = event.getChannelListenData();
            this.networkPort = this.myself.getPort();
            this.channelId = event.getChannelID();
            this.registerSharedChannel(this.channelId);
            try {
                this.subscribeNotifitcations();
                this.registerChannelEvents();
                this.registerMessages();
            }
            catch (HandlerRegistrationException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            this.unsubscribeNotification((short)1);
        }
    }

    private void uponContinuousTimeRandomWalkTimer(ContinuousTimeRandomWalkTimer timer, long time) {
        if (this.connectedNeighbors.isEmpty()) {
            logger.debug("No neighbors to start Continuous Time Random Walk");
            this.setupTimer(ContinuousTimeRandomWalkTimer.getInstance(), this.estimationTimeout);
            return;
        }
        Host next = (Host)this.connectedNeighbors.stream().skip(this.random.nextInt(this.connectedNeighbors.size())).findFirst().get();
        logger.debug("Starting Continuous Time Random Walk to {}", (Object)next);
        this.sendMessage(new SCPeerSamplingMessage(this.myself, this.initialWalkTime), next);
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        Host h = event.getNode();
        logger.trace("Host {} is down, cause: {}", (Object)h, (Object)event.getCause());
        if (this.connectedNeighbors.contains(h) || this.pending.contains(h)) {
            this.connectedNeighbors.remove(h);
            this.pending.add(h);
            this.openConnection(h);
        }
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        Host h = event.getNode();
        logger.trace("Connection to host {} failed, cause: {}", (Object)h, (Object)event.getCause());
        if (this.connectedNeighbors.contains(h) || this.pending.contains(h)) {
            this.connectedNeighbors.remove(h);
            this.pending.add(h);
            this.openConnection(h);
        }
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        Host h = event.getNode();
        logger.trace("Host (out) {} is up", (Object)h);
        if (!this.connectedNeighbors.contains(h) && !this.pending.contains(h)) {
            this.closeConnection(h);
            return;
        }
        this.pending.remove(h);
        this.connectedNeighbors.add(h);
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        logger.trace("Connection from host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void registerMessages() throws HandlerRegistrationException {
        this.registerMessageHandler(this.channelId, (short)2399, this::uponPeerSamplingMessage);
        this.registerMessageSerializer(this.channelId, (short)2399, SCPeerSamplingMessage.serializer);
        this.registerMessageHandler(this.channelId, (short)2400, this::uponPeerSamplingMessageReply);
        this.registerMessageSerializer(this.channelId, (short)2400, SCPeerSamplingMessageReply.serializer);
    }

    private void subscribeNotifitcations() throws HandlerRegistrationException {
        this.subscribeNotification((short)401, this::uponNeighborUp);
        this.subscribeNotification((short)402, this::uponNeighborDown);
    }

    private void registerChannelEvents() throws HandlerRegistrationException {
        this.registerChannelEventHandler(this.channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(this.channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(this.channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(this.channelId, (short)1, this::uponInConnectionDown);
    }
}

