package pt.unl.fct.di.novasys.babel.utils.recordexporter.utils;

import io.netty.buffer.ByteBuf;
import pt.unl.fct.di.novasys.babel.generic.ProtoNotification;
import pt.unl.fct.di.novasys.network.ISerializer;

public class ExportRecordNotification extends ProtoNotification {

    public final static short ID = 9191;
    private ReceiveRecord record;

    public ExportRecordNotification(ReceiveRecord record) {
        super(ID);
        this.record = record;
    }

    public ReceiveRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return this.record.toString();
    }

    public static final ISerializer<ExportRecordNotification> serializer = new ISerializer<ExportRecordNotification>() {
        @Override
        public void serialize(ExportRecordNotification m, ByteBuf out) {
            out.writeBytes(m.getRecord().toByteArray());
        }

        @Override
        public ExportRecordNotification deserialize(ByteBuf in) {
            byte[] bytes = new byte[in.readableBytes()];
            in.readBytes(bytes);
            ReceiveRecord record = ReceiveRecord.fromByteArray(bytes);
            return new ExportRecordNotification(record);
        }
    };

}
