package pt.unl.fct.di.novasys.babel.utils.recordexporter.utils;

import java.io.IOException;
import java.util.UUID;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import pt.unl.fct.di.novasys.network.data.Host;

public class ReceiveRecord {

    private Host node;
    private UUID messageId;
    private long timestampRecv;
    private long timestampSent;
    private Host from;
    private int hopCount;

    public ReceiveRecord(Host node, UUID messageId, long currentTimeMillis, long messageTimestamp, Host sender,
            int hopCount) {
        this.node = node;
        this.messageId = messageId;
        this.timestampRecv = currentTimeMillis;
        this.timestampSent = messageTimestamp;
        this.from = sender;
        this.hopCount = hopCount;
    }

    public Host getNode() {
        return node;
    }

    public UUID getMessageId() {
        return messageId;
    }

    public long getTimestampRecv() {
        return timestampRecv;
    }

    public long getTimestampSent() {
        return timestampSent;
    }

    public Host getFrom() {
        return from;
    }

    public int getHopCount() {
        return hopCount;
    }

    @Override
    public String toString() {
        return "ReceiveRecord{" +
                "node='" + node.toString() + '\'' +
                ", messageId=" + messageId +
                ", timestampRecv=" + timestampRecv +
                ", timestampSent=" + timestampSent +
                ", from='" + from.toString() + '\'' +
                ", hopCount=" + hopCount +
                '}';
    }

    public byte[] toByteArray() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            Host.serializer.serialize(node, buffer);
            Host.serializer.serialize(from, buffer);
            buffer.writeLong(timestampRecv);
            buffer.writeLong(timestampSent);
            buffer.writeInt(hopCount);
            buffer.writeLong(messageId.getMostSignificantBits());
            buffer.writeLong(messageId.getLeastSignificantBits());
            byte[] result = new byte[buffer.readableBytes()];
            buffer.readBytes(result);
            return result;
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            buffer.release(); // Release the ByteBuf
        }
    }

    public static ReceiveRecord fromByteArray(byte[] bytes) {
        ByteBuf buffer = Unpooled.wrappedBuffer(bytes);
        try {
            Host node = Host.serializer.deserialize(buffer); // Deserialize node
            Host from = Host.serializer.deserialize(buffer); // Deserialize from
            long timestampRecv = buffer.readLong();
            long timestampSent = buffer.readLong();
            int hopCount = buffer.readInt();
            long mostSigBits = buffer.readLong();
            long leastSigBits = buffer.readLong();
            UUID messageId = new UUID(mostSigBits, leastSigBits);
            return new ReceiveRecord(node, messageId, timestampRecv, timestampSent, from, hopCount);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            buffer.release(); // Release the ByteBuf
        }
    }
}
