package pt.unl.fct.di.novasys.babel.utils.recordexporter.utils;

import io.netty.buffer.ByteBuf;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;

public class SendRecordMessage extends ProtoMessage {

    public final static short ID = 9192;
    private ReceiveRecord record;

    public SendRecordMessage(ReceiveRecord record) {
        super(ID);
        this.record = record;
    }

    public ReceiveRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return this.record.toString();
    }

    public static final ISerializer<SendRecordMessage> serializer = new ISerializer<SendRecordMessage>() {
        @Override
        public void serialize(SendRecordMessage m, ByteBuf out) {
            out.writeBytes(m.getRecord().toByteArray());
        }

        @Override
        public SendRecordMessage deserialize(ByteBuf in) {
            byte[] bytes = new byte[in.readableBytes()];
            in.readBytes(bytes);
            ReceiveRecord record = ReceiveRecord.fromByteArray(bytes);
            return new SendRecordMessage(record);
        }
    };
}
