/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.recordexporter.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import pt.unl.fct.di.novasys.network.data.Host;

public class ReceiveRecord {
    private Host node;
    private UUID messageId;
    private long timestampRecv;
    private long timestampSent;
    private Host from;
    private int hopCount;

    public ReceiveRecord(Host node, UUID messageId, long currentTimeMillis, long messageTimestamp, Host sender, int hopCount) {
        this.node = node;
        this.messageId = messageId;
        this.timestampRecv = currentTimeMillis;
        this.timestampSent = messageTimestamp;
        this.from = sender;
        this.hopCount = hopCount;
    }

    public Host getNode() {
        return this.node;
    }

    public UUID getMessageId() {
        return this.messageId;
    }

    public long getTimestampRecv() {
        return this.timestampRecv;
    }

    public long getTimestampSent() {
        return this.timestampSent;
    }

    public Host getFrom() {
        return this.from;
    }

    public int getHopCount() {
        return this.hopCount;
    }

    public String toString() {
        return "ReceiveRecord{node='" + this.node.toString() + "', messageId=" + String.valueOf(this.messageId) + ", timestampRecv=" + this.timestampRecv + ", timestampSent=" + this.timestampSent + ", from='" + this.from.toString() + "', hopCount=" + this.hopCount + "}";
    }

    public byte[] toByteArray() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            Host.serializer.serialize((Object)this.node, buffer);
            Host.serializer.serialize((Object)this.from, buffer);
            buffer.writeLong(this.timestampRecv);
            buffer.writeLong(this.timestampSent);
            buffer.writeInt(this.hopCount);
            buffer.writeLong(this.messageId.getMostSignificantBits());
            buffer.writeLong(this.messageId.getLeastSignificantBits());
            byte[] result = new byte[buffer.readableBytes()];
            buffer.readBytes(result);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            buffer.release();
        }
    }

    public static ReceiveRecord fromByteArray(byte[] bytes) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bytes);
        try {
            Host node = (Host)Host.serializer.deserialize(buffer);
            Host from = (Host)Host.serializer.deserialize(buffer);
            long timestampRecv = buffer.readLong();
            long timestampSent = buffer.readLong();
            int hopCount = buffer.readInt();
            long mostSigBits = buffer.readLong();
            long leastSigBits = buffer.readLong();
            UUID messageId = new UUID(mostSigBits, leastSigBits);
            ReceiveRecord receiveRecord = new ReceiveRecord(node, messageId, timestampRecv, timestampSent, from, hopCount);
            return receiveRecord;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            buffer.release();
        }
    }
}

