/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.babel.utils.visualization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.InConnectionUp;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionDown;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionFailed;
import pt.unl.fct.di.novasys.channel.tcp.events.OutConnectionUp;
import pt.unl.fct.di.novasys.network.data.Host;

public class VisualizationProtocol
extends GenericProtocol {
    public static final short PROTO_ID = 8008;
    public static final String PROTO_NAME = "VisualizationProtocol";
    private Logger logger = LogManager.getLogger(VisualizationProtocol.class);
    public static final String DEFAULT_ID = "Membership";
    public static final String PAR_VISUALIZATION_ID = "Visualization.id";
    public static final String PAR_VISUALIZATION_ADDRESS = "Visualization.address";
    public static final String PAR_VISUALIZATION_PORT = "Visualization.port";
    private Host myself;
    private String baseURL;
    private int port;
    private String id;

    public VisualizationProtocol(Host myself) {
        super(PROTO_NAME, (short)8008);
        this.myself = myself;
    }

    public void init(Properties props) throws HandlerRegistrationException, IOException {
        Properties channelProperties = new Properties();
        channelProperties.setProperty("address", this.myself.getAddress().getHostAddress());
        channelProperties.setProperty("port", "" + this.myself.getPort());
        int channelId = this.createChannel("TCPChannel", channelProperties);
        if (props.containsKey(PAR_VISUALIZATION_ADDRESS) && props.containsKey(PAR_VISUALIZATION_PORT)) {
            this.baseURL = props.getProperty(PAR_VISUALIZATION_ADDRESS);
            this.port = Integer.parseInt(props.getProperty(PAR_VISUALIZATION_PORT));
        } else {
            this.logger.error("Missing visualization tool configuration");
            System.exit(1);
        }
        this.id = props.getProperty(PAR_VISUALIZATION_ID, DEFAULT_ID);
        this.subscribeNotification((short)401, this::handleNeighborUp);
        this.subscribeNotification((short)402, this::handleNeighborDown);
        this.registerChannelEventHandler(channelId, (short)3, this::uponOutConnectionDown);
        this.registerChannelEventHandler(channelId, (short)4, this::uponOutConnectionFailed);
        this.registerChannelEventHandler(channelId, (short)5, this::uponOutConnectionUp);
        this.registerChannelEventHandler(channelId, (short)2, this::uponInConnectionUp);
        this.registerChannelEventHandler(channelId, (short)1, this::uponInConnectionDown);
    }

    public static void sendGetRequest(String baseUrl, int port, String path, String id, String filename) throws Exception {
        String query = "id=" + id;
        if (filename != null) {
            query = query + "&filename=" + filename;
        }
        URI uri = new URI("http", null, baseUrl, port, path, query, null);
        URL fullUrl = uri.toURL();
        HttpURLConnection connection = (HttpURLConnection)fullUrl.openConnection();
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        System.out.println("Response Code: " + responseCode);
        if (responseCode == 200) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                System.out.println("Response: " + response.toString());
            }
        } else {
            System.out.println("GET request failed");
        }
        connection.disconnect();
    }

    public void sendPostRequest(String url, int port, String path, String id, String node, String neighbour) throws Exception {
        URL fullUrl = new URI("http", null, url, port, path, null, null).toURL();
        String jsonPayload = String.format("{\"id\": \"%s\", \"node\": \"%s\", \"neighbour\": \"%s\"}", id, node, neighbour);
        HttpURLConnection connection = (HttpURLConnection)fullUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonPayload.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        int responseCode = connection.getResponseCode();
        System.out.println("Response Code: " + responseCode);
        connection.disconnect();
    }

    public void handleNeighborUp(NeighborUp n, short proto) {
        String neighbour = n.getPeer().getAddress().toString();
        try {
            this.sendPostRequest(this.baseURL, this.port, "/add_edge", this.id, this.myself.getAddress().toString(), neighbour);
            VisualizationProtocol.sendGetRequest(this.baseURL, this.port, "", this.id, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleNeighborDown(NeighborDown n, short proto) {
        String neighbour = n.getPeer().getAddress().toString();
        try {
            this.sendPostRequest(this.baseURL, this.port, "/remove_edge", this.id, this.myself.getAddress().toString(), neighbour);
            VisualizationProtocol.sendGetRequest(this.baseURL, this.port, "", this.id, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void uponOutConnectionDown(OutConnectionDown event, int channelId) {
        this.logger.trace("Host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void uponOutConnectionFailed(OutConnectionFailed<?> event, int channelId) {
        this.logger.trace("Connection to host {} failed, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }

    private void uponOutConnectionUp(OutConnectionUp event, int channelId) {
        this.logger.trace("Host (out) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionUp(InConnectionUp event, int channelId) {
        this.logger.trace("Host (in) {} is up", (Object)event.getNode());
    }

    private void uponInConnectionDown(InConnectionDown event, int channelId) {
        this.logger.trace("Connection from host {} is down, cause: {}", (Object)event.getNode(), (Object)event.getCause());
    }
}

