package pt.unl.fct.di.novasys.babel.utils.visualization;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import pt.unl.fct.di.novasys.babel.core.GenericProtocol;
import pt.unl.fct.di.novasys.babel.exceptions.HandlerRegistrationException;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborDown;
import pt.unl.fct.di.novasys.babel.protocols.membership.notifications.NeighborUp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Properties;

public class VisualizationProtocol extends GenericProtocol {
	public static final short PROTO_ID = 8008;
	public static final String PROTO_NAME = "VisualizationProtocol";

	private Logger logger = LogManager.getLogger(VisualizationProtocol.class);

	public static final String DEFAULT_ID = "Membership";

	public static final String PAR_VISUALIZATION_ID = "Visualization.id";
	public static final String PAR_VISUALIZATION_ADDRESS = "Visualization.address";
	public static final String PAR_VISUALIZATION_PORT = "Visualization.port";

	private Host myself;
	private String baseURL;
	private int port;
	private String id;

	public VisualizationProtocol(Host myself) {
		super(PROTO_NAME, PROTO_ID);

		this.myself = myself;
	}

	@Override
	public void init(Properties props) throws HandlerRegistrationException, IOException {
		if (props.containsKey(PAR_VISUALIZATION_ADDRESS) && props.containsKey(PAR_VISUALIZATION_PORT)) {
			this.baseURL = props.getProperty(PAR_VISUALIZATION_ADDRESS);
			this.port = Integer.parseInt(props.getProperty(PAR_VISUALIZATION_PORT));
		} else {
			logger.error("Missing visualization tool configuration");
			System.exit(1);
		}

		this.id = props.getProperty(PAR_VISUALIZATION_ID, DEFAULT_ID);

		/*-------------------- Register Notification Handlers ------------------------ */
		subscribeNotification(NeighborUp.NOTIFICATION_ID, this::handleNeighborUp);
		subscribeNotification(NeighborDown.NOTIFICATION_ID, this::handleNeighborDown);
	}

	public static void sendGetRequest(String baseUrl, int port, String path, String id, String filename) throws Exception {
		String query = "id="+id;
		if (filename != null) {
			query += "&filename="+filename;
		}

		URI uri = new URI("http", null, baseUrl, port, path, query, null);
        URL fullUrl = uri.toURL();

        // Open connection
        HttpURLConnection connection = (HttpURLConnection) fullUrl.openConnection();
        connection.setRequestMethod("GET");

        // Get the response
        int responseCode = connection.getResponseCode();
        System.out.println("Response Code: " + responseCode);

        if (responseCode == HttpURLConnection.HTTP_OK) { // success
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()))) {
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                System.out.println("Response: " + response.toString());
            }
        } else {
            System.out.println("GET request failed");
        }

        // Close connection
        connection.disconnect();
    }

	public void sendPostRequest(String url, int port, String path, String id, String node, String neighbour) throws Exception {
		// Construct the URL with the port
		URL fullUrl = new URI("http", null, url, port, path, null, null).toURL();

		// Create the JSON payload
		String jsonPayload = String.format("{\"id\": \"%s\", \"node\": \"%s\", \"neighbour\": \"%s\"}", id, node,
				neighbour);

		// Open connection
		HttpURLConnection connection = (HttpURLConnection) fullUrl.openConnection();
		connection.setDoOutput(true);
		connection.setRequestMethod("POST");
		connection.setRequestProperty("Content-Type", "application/json");

		// Write JSON to the output stream
		try (OutputStream os = connection.getOutputStream()) {
			byte[] input = jsonPayload.getBytes("utf-8");
			os.write(input, 0, input.length);
		}

		// Get the response code (optional, for verification)
		int responseCode = connection.getResponseCode();
		System.out.println("Response Code: " + responseCode);

		// Close the connection
		connection.disconnect();
	}

	public void handleNeighborUp(NeighborUp n, short proto) {
		String neighbour = n.getPeer().getAddress().toString();

		try {
			sendPostRequest(this.baseURL, this.port, "/add_edge", this.id, this.myself.getAddress().toString(), neighbour);
			sendGetRequest(this.baseURL, port, "", this.id, null);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void handleNeighborDown(NeighborDown n, short proto) {
		String neighbour = n.getPeer().getAddress().toString();

		try {
			sendPostRequest(this.baseURL, this.port, "/remove_edge", this.id, this.myself.getAddress().toString(), neighbour);
			sendGetRequest(this.baseURL, port, "", this.id, null);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
