/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.utils;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import pt.unl.fct.di.novasys.network.ISerializer;

public enum ECPubKeySerializer implements ISerializer<ECPublicKey>
{
    INSTANCE;

    private final KeyFactory keyFactory;

    private ECPubKeySerializer() {
        KeyFactory fac;
        try {
            fac = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            fac = null;
        }
        this.keyFactory = fac;
    }

    @Override
    public void serialize(ECPublicKey dhPubKey, ByteBuf out) {
        byte[] encodedKey = dhPubKey.getEncoded();
        out.writeInt(encodedKey.length);
        out.writeBytes(encodedKey);
    }

    @Override
    public ECPublicKey deserialize(ByteBuf in) throws IOException {
        byte[] encodedKey = new byte[in.readInt()];
        in.readBytes(encodedKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        try {
            return (ECPublicKey)this.keyFactory.generatePublic(keySpec);
        }
        catch (ClassCastException | InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }
}

