/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.secure.weakauth;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import pt.unl.fct.di.novasys.channel.secure.SecureChannelListener;
import pt.unl.fct.di.novasys.channel.secure.SecureSingleThreadedBiChannel;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureInConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionDown;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionFailed;
import pt.unl.fct.di.novasys.channel.secure.events.SecureOutConnectionUp;
import pt.unl.fct.di.novasys.channel.secure.utils.X509CertificateSerializer;
import pt.unl.fct.di.novasys.channel.tcp.ConnectionState;
import pt.unl.fct.di.novasys.channel.tcp.events.ChannelMetrics;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Bytes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeAttributesException;
import pt.unl.fct.di.novasys.network.security.X509IKeyManager;
import pt.unl.fct.di.novasys.network.security.X509ITrustManager;

public class WeakAuthChannel<T>
extends SecureSingleThreadedBiChannel<T, T>
implements AttributeValidator {
    private static final Logger logger = LogManager.getLogger(WeakAuthChannel.class);
    public static final short CHANNEL_MAGIC_NUMBER = 21764;
    public static final String NAME = "WeakAuthChannel";
    public static final String ADDRESS_KEY = "address";
    public static final String PORT_KEY = "port";
    public static final String WORKER_GROUP_KEY = "worker_group";
    public static final String TRIGGER_SENT_KEY = "trigger_sent";
    public static final String METRICS_INTERVAL_KEY = "metrics_interval";
    public static final String HEARTBEAT_INTERVAL_KEY = "heartbeat_interval";
    public static final String HEARTBEAT_TOLERANCE_KEY = "heartbeat_tolerance";
    public static final String CONNECT_TIMEOUT_KEY = "connect_timeout";
    public static final String NONCE_SIZE_KEY = "nonce_length";
    public static final String LISTEN_ADDRESS_ATTRIBUTE = "listen_address";
    public static final String DEFAULT_PORT = "9572";
    public static final String DEFAULT_HB_INTERVAL = "0";
    public static final String DEFAULT_HB_TOLERANCE = "0";
    public static final String DEFAULT_CONNECT_TIMEOUT = "1000";
    public static final String DEFAULT_METRICS_INTERVAL = "-1";
    public static final String DEFAULT_NONCE_SIZE = "8";
    public static final int CONNECTION_OUT = 0;
    public static final int CONNECTION_IN = 1;
    private static final byte HANDSHAKE_STEPS = 3;
    private final NetworkManager<T> network;
    private final SecureChannelListener<T> listener;
    private final Attributes attributes;
    private final Map<Bytes, Host> peerHosts;
    private final Map<Host, byte[]> hostIds;
    private final Map<Host, LinkedList<Connection<T>>> inConnections;
    private final Map<Host, ConnectionState<T>> outConnections;
    private List<Pair<Host, Connection<T>>> oldIn;
    private List<Pair<Host, ConnectionState<T>>> oldOUt;
    private final boolean triggerSent;
    private final boolean metrics;
    private final Provider securityProvider;
    private final SecureRandom nonceRng;
    private final int nonceSize;
    private final X509IKeyManager keyManager;
    private final X509ITrustManager trustManager;
    private static final String EXPECTED_ID_ATTR = "expected_id";
    private static final String ID_ATTR = "id";
    private static final String CERT_ATTR = "certificate";
    private static final String NONCE_ATTR = "nonce";
    private static final String SIG_NONCE_ATTR = "signed_nonce";

    public WeakAuthChannel(ISerializer<T> serializer, SecureChannelListener<T> list, Properties properties, X509IKeyManager keyManager, X509ITrustManager trustManager) throws IOException {
        super(NAME);
        SecureRandom rng;
        this.listener = list;
        this.securityProvider = new BouncyCastleProvider();
        try {
            rng = SecureRandom.getInstance("NonceAndIV", this.securityProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Failed to get \"NonceAndIV\" secure random");
            rng = new SecureRandom();
        }
        this.nonceRng = rng;
        this.keyManager = keyManager;
        this.trustManager = trustManager;
        if (!properties.containsKey(ADDRESS_KEY)) {
            throw new IllegalArgumentException("WeakAuthChannel requires binding address");
        }
        InetAddress addr = Inet4Address.getByName(properties.getProperty(ADDRESS_KEY));
        int port = Integer.parseInt(properties.getProperty(PORT_KEY, DEFAULT_PORT));
        int hbInterval = Integer.parseInt(properties.getProperty(HEARTBEAT_INTERVAL_KEY, "0"));
        int hbTolerance = Integer.parseInt(properties.getProperty(HEARTBEAT_TOLERANCE_KEY, "0"));
        int connTimeout = Integer.parseInt(properties.getProperty(CONNECT_TIMEOUT_KEY, DEFAULT_CONNECT_TIMEOUT));
        int metricsInterval = Integer.parseInt(properties.getProperty(METRICS_INTERVAL_KEY, DEFAULT_METRICS_INTERVAL));
        this.triggerSent = Boolean.parseBoolean(properties.getProperty(TRIGGER_SENT_KEY, "false"));
        this.metrics = metricsInterval > 0;
        this.nonceSize = Integer.parseInt(properties.getProperty(NONCE_SIZE_KEY, DEFAULT_NONCE_SIZE));
        Host listenAddress = new Host(addr, port);
        EventLoopGroup eventExecutors = properties.containsKey(WORKER_GROUP_KEY) ? (EventLoopGroup)properties.get(WORKER_GROUP_KEY) : NetworkManager.createNewWorkerGroup();
        this.network = new NetworkManager<T>(3, serializer, this, hbInterval, hbTolerance, connTimeout, eventExecutors);
        this.network.createServerSocket(this, listenAddress, (AttributeValidator)this, eventExecutors);
        this.attributes = new Attributes();
        this.attributes.putShort("magic_number", (short)21764);
        this.attributes.putHost(LISTEN_ADDRESS_ATTRIBUTE, listenAddress);
        this.peerHosts = new HashMap<Bytes, Host>();
        this.hostIds = new HashMap<Host, byte[]>();
        this.inConnections = new HashMap<Host, LinkedList<Connection<T>>>();
        this.outConnections = new HashMap<Host, ConnectionState<T>>();
        if (this.metrics) {
            this.oldIn = new LinkedList<Pair<Host, Connection<T>>>();
            this.oldOUt = new LinkedList<Pair<Host, ConnectionState<T>>>();
            this.loop.scheduleAtFixedRate(this::triggerMetricsEvent, (long)metricsInterval, (long)metricsInterval, TimeUnit.MILLISECONDS);
        }
    }

    void triggerMetricsEvent() {
        this.listener.deliverEvent(new ChannelMetrics(this.oldIn, this.oldOUt, this.inConnections, this.outConnections));
    }

    @Override
    public boolean validateAttributes(Attributes attr) {
        Short channel = attr.getShort("magic_number");
        return channel != null && channel == 21764;
    }

    private Attributes getFirstHandshakeAttributes(byte[] expectedId) {
        String idAlias;
        Attributes attrs = this.attributes.shallowClone();
        if (expectedId != null) {
            attrs.putBytes(EXPECTED_ID_ATTR, expectedId);
        }
        if ((idAlias = this.keyManager.chooseServerAlias("RSA", null, null)) == null) {
            idAlias = this.keyManager.chooseServerAlias(null, null, null);
        }
        byte[] id = this.keyManager.getAliasId(idAlias);
        attrs.putBytes(ID_ATTR, id);
        X509Certificate cert = this.keyManager.getCertificateChain(idAlias)[0];
        try {
            attrs.putObject(CERT_ATTR, cert, X509CertificateSerializer.INSTANCE);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        byte[] nonce = new byte[this.nonceSize];
        this.nonceRng.nextBytes(nonce);
        attrs.putBytes(NONCE_ATTR, nonce);
        return attrs;
    }

    @Override
    public Attributes getSecondHandshakeAttributes(long channelId, Attributes peerAttr, Attributes myAttr) throws InvalidHandshakeAttributesException {
        if (!this.validateAttributes(peerAttr)) {
            throw new InvalidHandshakeAttributesException(peerAttr, 1);
        }
        try {
            PrivateKey privKey;
            X509Certificate myCert;
            X509Certificate peerCert = peerAttr.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
            byte[] peerId = this.trustManager.extractIdFromCertificate(peerCert);
            if (!Arrays.equals(peerId, peerAttr.getBytes(ID_ATTR))) {
                logger.debug("In connection attribute validation failed: peer id in attributes ({}) differs from the one extracted from certificate ({})", (Object)Bytes.of(peerId), (Object)Bytes.of(peerAttr.getBytes(ID_ATTR)));
                throw new InvalidHandshakeAttributesException(peerAttr, 1);
            }
            this.trustManager.checkClientTrusted(new X509Certificate[]{peerCert}, peerCert.getSigAlgName());
            Attributes attrs = myAttr.shallowClone();
            byte[] myId = peerAttr.getBytes(EXPECTED_ID_ATTR);
            if (myId != null) {
                myCert = this.keyManager.getCertificateChain(myId)[0];
                privKey = this.keyManager.getPrivateKey(myId);
            } else {
                String alias = this.keyManager.chooseServerAlias("RSA", null, null);
                if (alias == null) {
                    alias = this.keyManager.chooseServerAlias(null, null, null);
                }
                myId = this.keyManager.getAliasId(alias);
                myCert = this.keyManager.getCertificateChain(alias)[0];
                privKey = this.keyManager.getPrivateKey(alias);
            }
            attrs.putBytes(ID_ATTR, myId);
            attrs.putObject(CERT_ATTR, myCert, X509CertificateSerializer.INSTANCE);
            byte[] signedNonce = this.signNonce(attrs.getBytes(NONCE_ATTR), myCert, privKey);
            attrs.putBytes(SIG_NONCE_ATTR, signedNonce);
            byte[] nonce = new byte[this.nonceSize];
            this.nonceRng.nextBytes(nonce);
            attrs.putBytes(NONCE_ATTR, nonce);
            return attrs;
        }
        catch (IOException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException e) {
            throw new InvalidHandshakeAttributesException(peerAttr, 1, (Throwable)e);
        }
    }

    private byte[] signNonce(byte[] nonce, X509Certificate myCert, PrivateKey privKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(myCert.getSigAlgName(), this.securityProvider);
        signature.initSign(privKey);
        signature.update(nonce);
        return signature.sign();
    }

    @Override
    public Attributes getNthHandshakeAttributes(long channelId, int handshakeN, List<Attributes> peerAttrs, List<Attributes> mySentAttrs) throws InvalidHandshakeAttributesException {
        try {
            if (handshakeN == 3) {
                Attributes firstHsAttrs = mySentAttrs.getFirst();
                Attributes secondHsAttrs = peerAttrs.getFirst();
                X509Certificate peerCert = secondHsAttrs.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
                byte[] peerId = this.trustManager.extractIdFromCertificate(peerCert);
                if (!Arrays.equals(peerId, secondHsAttrs.getBytes(ID_ATTR))) {
                    logger.debug("Out connection attribute validation failed: peer id in attributes ({}) differs from the one extracted from certificate ({})", (Object)Bytes.of(peerId), (Object)Bytes.of(secondHsAttrs.getBytes(ID_ATTR)));
                    throw new InvalidHandshakeAttributesException(secondHsAttrs, 2);
                }
                this.trustManager.checkClientTrusted(new X509Certificate[]{peerCert}, peerCert.getSigAlgName());
                byte[] sentNonce = firstHsAttrs.getBytes(NONCE_ATTR);
                byte[] recvdSignedNonce = secondHsAttrs.getBytes(SIG_NONCE_ATTR);
                Signature sig = Signature.getInstance(peerCert.getSigAlgName(), this.securityProvider);
                sig.initVerify(peerCert.getPublicKey());
                sig.update(sentNonce);
                if (!sig.verify(recvdSignedNonce)) {
                    logger.debug("Out connection attribute validation failed: sent nonce wasn't correctly signed.");
                    throw new InvalidHandshakeAttributesException(secondHsAttrs, 2);
                }
                Attributes attrs = new Attributes();
                byte[] myId = firstHsAttrs.getBytes(ID_ATTR);
                byte[] signedNonce = this.signNonce(secondHsAttrs.getBytes(NONCE_ATTR), this.keyManager.getCertificateChain(myId)[0], this.keyManager.getPrivateKey(myId));
                attrs.putBytes(SIG_NONCE_ATTR, signedNonce);
                return attrs;
            }
            if (handshakeN == 4) {
                Attributes firstHsAttrs = peerAttrs.getFirst();
                Attributes thirdHsAttrs = peerAttrs.getLast();
                X509Certificate peerCert = firstHsAttrs.getObject(CERT_ATTR, X509CertificateSerializer.INSTANCE);
                byte[] sentNonce = mySentAttrs.getFirst().getBytes(NONCE_ATTR);
                byte[] recvdSignedNonce = thirdHsAttrs.getBytes(SIG_NONCE_ATTR);
                Signature sig = Signature.getInstance(peerCert.getSigAlgName(), this.securityProvider);
                sig.initVerify(peerCert.getPublicKey());
                sig.update(sentNonce);
                if (!sig.verify(recvdSignedNonce)) {
                    logger.debug("In connection attribute validation failed: sent nonce wasn't correctly signed.");
                    throw new InvalidHandshakeAttributesException(thirdHsAttrs, 3);
                }
                return Attributes.EMPTY;
            }
            throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1);
        }
        catch (IOException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException | NoSuchElementException e) {
            throw new InvalidHandshakeAttributesException(peerAttrs.getLast(), handshakeN - 1, (Throwable)e);
        }
    }

    @Override
    protected void onOpenConnection(Host peer, int connection) {
        ConnectionState<T> conState = this.outConnections.get(peer);
        if (conState == null) {
            logger.debug("onOpenConnection creating connection to: " + String.valueOf(peer));
            Attributes attrs = this.getFirstHandshakeAttributes(null);
            this.outConnections.put(peer, new ConnectionState<T>(this.network.createConnection(peer, attrs, this, this)));
        } else if (conState.getState() == ConnectionState.State.DISCONNECTING) {
            logger.debug("onOpenConnection reopening after close to: " + String.valueOf(peer));
            conState.setState(ConnectionState.State.DISCONNECTING_RECONNECT);
        } else {
            logger.debug("onOpenConnection ignored: " + String.valueOf(peer));
        }
    }

    @Override
    protected void onOpenConnection(Host peer, byte[] expectedId, int connection) {
        ConnectionState<T> conState = this.outConnections.get(peer);
        if (conState == null || this.peerHosts.containsKey(Bytes.of(expectedId))) {
            logger.debug("onOpenConnection creating connection to: " + String.valueOf(peer));
            Attributes attrs = this.getFirstHandshakeAttributes(expectedId);
            this.outConnections.put(peer, new ConnectionState<T>(this.network.createConnection(peer, attrs, this, this)));
        } else if (conState.getState() == ConnectionState.State.DISCONNECTING) {
            logger.debug("onOpenConnection reopening after close to: {} - {}", (Object)peer, (Object)Bytes.of(expectedId));
            conState.setState(ConnectionState.State.DISCONNECTING_RECONNECT);
        } else {
            logger.debug("onOpenConnection ignored: {} - {}", (Object)peer, (Object)Bytes.of(expectedId));
        }
    }

    @Override
    protected void onSendMessage(T msg, byte[] peerIdentity, int connection) {
        Host host = this.peerHosts.get(Bytes.of(peerIdentity));
        if (host == null) {
            this.listener.messageFailed(msg, Optional.empty(), peerIdentity, new IllegalArgumentException("No open connection to peer with id " + String.valueOf(Bytes.of(peerIdentity))));
        } else {
            this.onSendMessage(msg, host, connection);
        }
    }

    @Override
    protected void onSendMessage(T msg, Host peer, int connection) {
        logger.debug("SendMessage " + String.valueOf(msg) + " " + String.valueOf(peer) + " " + (connection == 1 ? "IN" : "OUT"));
        byte[] peerId = this.hostIds.get(peer);
        if (connection <= 0) {
            ConnectionState<T> conState = this.outConnections.get(peer);
            if (conState != null) {
                if (conState.getState() == ConnectionState.State.CONNECTING || conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT) {
                    conState.getQueue().add(msg);
                } else if (conState.getState() == ConnectionState.State.CONNECTED) {
                    this.sendWithListener(msg, peer, peerId, conState.getConnection());
                } else if (conState.getState() == ConnectionState.State.DISCONNECTING) {
                    conState.getQueue().add(msg);
                    conState.setState(ConnectionState.State.DISCONNECTING_RECONNECT);
                }
            } else {
                this.listener.messageFailed(msg, Optional.of(peer), peerId, new IllegalArgumentException("No outgoing connection"));
            }
        } else if (connection == 1) {
            LinkedList<Connection<T>> inConnList = this.inConnections.get(peer);
            if (inConnList != null) {
                this.sendWithListener(msg, peer, peerId, inConnList.getLast());
            } else {
                this.listener.messageFailed(msg, Optional.of(peer), peerId, new IllegalArgumentException("No incoming connection"));
            }
        } else {
            this.listener.messageFailed(msg, Optional.of(peer), peerId, new IllegalArgumentException("Invalid connection: " + connection));
            logger.error("Invalid sendMessage mode " + connection);
        }
    }

    private void sendWithListener(T msg, Host peer, byte[] peerId, Connection<T> established) {
        Promise promise = this.loop.newPromise();
        promise.addListener(future -> {
            if (future.isSuccess() && this.triggerSent) {
                this.listener.messageSent(msg, peer, peerId);
            } else if (!future.isSuccess()) {
                this.listener.messageFailed(msg, Optional.of(peer), peerId, future.cause());
            }
        });
        established.sendMessage(msg, (Promise<Void>)promise);
    }

    @Override
    protected void onOutboundConnectionUp(Connection<T> conn) {
        Host peerHost = conn.getPeer();
        byte[] peerId = conn.getPeerAttributes().getBytes(ID_ATTR);
        logger.debug("OutboundConnectionUp {} - {}", (Object)peerHost, (Object)Bytes.of(peerId));
        ConnectionState<T> conState = this.outConnections.get(conn.getPeer());
        if (conState == null) {
            throw new AssertionError((Object)("ConnectionUp with no conState: " + String.valueOf(conn)));
        }
        if (conState.getState() == ConnectionState.State.CONNECTED) {
            throw new AssertionError((Object)("ConnectionUp in CONNECTED state: " + String.valueOf(conn)));
        }
        if (conState.getState() == ConnectionState.State.CONNECTING) {
            conState.setState(ConnectionState.State.CONNECTED);
            conState.getQueue().forEach(m -> this.sendWithListener(m, peerHost, peerId, conn));
            conState.getQueue().clear();
            this.listener.deliverEvent(new SecureOutConnectionUp(peerHost, peerId));
        }
    }

    @Override
    protected void onCloseConnection(byte[] peerId, int connection) {
        Host host = this.peerHosts.get(Bytes.of(peerId));
        if (host == null) {
            logger.debug("CloseConection: No connection to " + String.valueOf(Bytes.of(peerId)));
        } else {
            this.onCloseConnection(host, connection);
        }
    }

    @Override
    protected void onCloseConnection(Host peer, int connection) {
        logger.debug("CloseConnection " + String.valueOf(peer));
        ConnectionState<T> conState = this.outConnections.get(peer);
        if (conState != null && (conState.getState() == ConnectionState.State.CONNECTED || conState.getState() == ConnectionState.State.CONNECTING || conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT)) {
            conState.setState(ConnectionState.State.DISCONNECTING);
            conState.getQueue().clear();
            conState.getConnection().disconnect();
            if (!this.inConnections.containsKey(peer)) {
                this.peerHosts.remove(Bytes.of(this.hostIds.remove(peer)));
            }
        }
    }

    @Override
    protected void onOutboundConnectionDown(Connection<T> conn, Throwable cause) {
        Host host = conn.getPeer();
        logger.debug("OutboundConnectionDown " + String.valueOf(host) + (String)(cause != null ? " " + String.valueOf(cause) : ""));
        ConnectionState<T> conState = this.outConnections.remove(conn.getPeer());
        Bytes peerId = Bytes.of(this.hostIds.get(host));
        if (!this.inConnections.containsKey(conn.getPeer())) {
            this.hostIds.remove(host);
            this.peerHosts.remove(peerId);
        }
        if (conState == null) {
            throw new AssertionError((Object)("ConnectionDown with no conState: " + String.valueOf(conn)));
        }
        if (conState.getState() == ConnectionState.State.CONNECTING) {
            throw new AssertionError((Object)("ConnectionDown in CONNECTING state: " + String.valueOf(conn)));
        }
        if (conState.getState() == ConnectionState.State.CONNECTED) {
            this.listener.deliverEvent(new SecureOutConnectionDown(conn.getPeer(), peerId, cause));
        } else if (conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT) {
            Attributes attrs = this.getFirstHandshakeAttributes(peerId.array());
            this.outConnections.put(conn.getPeer(), new ConnectionState<T>(this.network.createConnection(conn.getPeer(), attrs, this, this), conState.getQueue()));
        }
        if (this.metrics) {
            this.oldOUt.add(Pair.of((Object)conn.getPeer(), conState));
        }
    }

    @Override
    protected void onOutboundConnectionFailed(Connection<T> conn, Throwable cause) {
        ConnectionState<T> conState;
        logger.debug("OutboundConnectionFailed " + String.valueOf(conn.getPeer()) + (String)(cause != null ? " " + String.valueOf(cause) : ""));
        byte[] peerId = conn.getPeerAttributes().getBytes(ID_ATTR);
        if (peerId == null) {
            peerId = conn.getSelfAttributes().getBytes(EXPECTED_ID_ATTR);
        }
        if ((conState = this.outConnections.remove(conn.getPeer())) == null) {
            throw new AssertionError((Object)("ConnectionFailed with no conState: " + String.valueOf(conn)));
        }
        if (conState.getState() == ConnectionState.State.CONNECTING) {
            this.listener.deliverEvent(new SecureOutConnectionFailed<T>(conn.getPeer(), peerId, conState.getQueue(), cause));
        } else if (conState.getState() == ConnectionState.State.DISCONNECTING_RECONNECT) {
            Attributes attrs = this.getFirstHandshakeAttributes(peerId);
            this.outConnections.put(conn.getPeer(), new ConnectionState<T>(this.network.createConnection(conn.getPeer(), attrs, this, this), conState.getQueue()));
        } else if (conState.getState() == ConnectionState.State.CONNECTED) {
            throw new AssertionError((Object)("ConnectionFailed in state: " + String.valueOf((Object)conState.getState()) + " - " + String.valueOf(conn)));
        }
        if (this.metrics) {
            this.oldOUt.add(Pair.of((Object)conn.getPeer(), conState));
        }
    }

    @Override
    protected void onInboundConnectionUp(Connection<T> con) {
        Host clientSocket;
        try {
            clientSocket = con.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTRIBUTE);
        }
        catch (IOException e) {
            logger.error("Inbound connection without valid listen address in connectionUp: " + e.getMessage());
            con.disconnect();
            return;
        }
        byte[] peerId = this.hostIds.get(clientSocket);
        byte[] idFromAttrs = con.getPeerAttributes().getBytes(ID_ATTR);
        if (peerId == null) {
            peerId = idFromAttrs;
        } else if (!Arrays.equals(peerId, idFromAttrs)) {
            logger.error("Inbound connection from {} with inconsitent identity. Expected {} but was {}", (Object)clientSocket, (Object)Bytes.of(peerId), (Object)Bytes.of(idFromAttrs));
            con.disconnect();
            return;
        }
        Host knownHost = this.peerHosts.get(Bytes.of(peerId));
        if (knownHost != null && !knownHost.equals(clientSocket)) {
            logger.error("Inbound connection from {} with inconsitent host address. Expected {} but was {}", (Object)Bytes.of(peerId), (Object)knownHost, (Object)clientSocket);
            con.disconnect();
            return;
        }
        this.hostIds.put(clientSocket, peerId);
        this.peerHosts.put(Bytes.of(peerId), clientSocket);
        LinkedList inConnList = this.inConnections.computeIfAbsent(clientSocket, k -> new LinkedList());
        inConnList.add(con);
        if (inConnList.size() == 1) {
            logger.debug("InboundConnectionUp " + String.valueOf(clientSocket));
            this.listener.deliverEvent(new SecureInConnectionUp(clientSocket, peerId));
        } else {
            logger.debug("Multiple InboundConnectionUp " + inConnList.size() + String.valueOf(clientSocket));
        }
    }

    @Override
    protected void onInboundConnectionDown(Connection<T> con, Throwable cause) {
        Host clientSocket;
        try {
            clientSocket = con.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTRIBUTE);
        }
        catch (IOException e) {
            logger.error("Inbound connection without valid listen address in connectionDown: " + e.getMessage());
            con.disconnect();
            return;
        }
        LinkedList<Connection<T>> inConnList = this.inConnections.get(clientSocket);
        if (inConnList == null || inConnList.isEmpty()) {
            throw new AssertionError((Object)("No connections in InboundConnectionDown " + String.valueOf(clientSocket)));
        }
        if (!inConnList.remove(con)) {
            throw new AssertionError((Object)("No connection in InboundConnectionDown " + String.valueOf(clientSocket)));
        }
        if (inConnList.isEmpty()) {
            logger.debug("InboundConnectionDown " + String.valueOf(clientSocket) + (String)(cause != null ? " " + String.valueOf(cause) : ""));
            byte[] peerId = this.hostIds.get(clientSocket);
            if (!this.outConnections.containsKey(clientSocket)) {
                this.hostIds.remove(clientSocket);
                this.peerHosts.remove(Bytes.of(peerId));
            }
            this.listener.deliverEvent(new SecureInConnectionDown(clientSocket, peerId, cause));
            this.inConnections.remove(clientSocket);
        } else {
            logger.debug("Extra InboundConnectionDown " + inConnList.size() + String.valueOf(clientSocket));
        }
        if (this.metrics) {
            this.oldIn.add(Pair.of((Object)clientSocket, con));
        }
    }

    @Override
    public void onServerSocketBind(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket ready");
        } else {
            logger.error("Server socket bind failed: " + String.valueOf(cause));
        }
    }

    @Override
    public void onServerSocketClose(boolean success, Throwable cause) {
        logger.debug("Server socket closed. " + (String)(success ? "" : "Cause: " + String.valueOf(cause)));
    }

    @Override
    public void onDeliverMessage(T msg, Connection<T> conn) {
        byte[] peerId = conn.getPeerAttributes().getBytes(ID_ATTR);
        if (peerId == null) {
            logger.error("onDeliverMessage error: No identity associated with connection to host {}", (Object)conn.getPeer());
            return;
        }
        Host host = conn.getPeer();
        if (conn.isInbound()) {
            try {
                host = conn.getPeerAttributes().getHost(LISTEN_ADDRESS_ATTRIBUTE);
            }
            catch (IOException e) {
                logger.error("Inbound connection without valid listen address in deliver message: " + e.getMessage());
                conn.disconnect();
                return;
            }
        }
        logger.debug("DeliverMessage " + String.valueOf(msg) + " " + String.valueOf(host) + " " + (conn.isInbound() ? "IN" : "OUT"));
        this.listener.deliverMessage(msg, host, peerId);
    }
}

