/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.simpleclientserver;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Promise;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.channel.ChannelListener;
import pt.unl.fct.di.novasys.channel.base.SingleThreadedClientChannel;
import pt.unl.fct.di.novasys.channel.simpleclientserver.events.ServerDownEvent;
import pt.unl.fct.di.novasys.channel.simpleclientserver.events.ServerFailedEvent;
import pt.unl.fct.di.novasys.channel.simpleclientserver.events.ServerUpEvent;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;

public class SimpleClientChannel<T>
extends SingleThreadedClientChannel<T, T> {
    private static final Logger logger = LogManager.getLogger(SimpleClientChannel.class);
    public static final short SIMPLE_CLIENT_MAGIC_NUMBER = 23749;
    public static final String NAME = "ClientChannel";
    public static final String ADDRESS_KEY = "address";
    public static final String PORT_KEY = "port";
    public static final String WORKER_GROUP_KEY = "workerGroup";
    public static final String HEARTBEAT_INTERVAL_KEY = "heartbeat_interval";
    public static final String HEARTBEAT_TOLERANCE_KEY = "heartbeat_tolerance";
    public static final String CONNECT_TIMEOUT_KEY = "connect_timeout";
    public static final String DEFAULT_PORT = "13174";
    public static final String DEFAULT_HB_INTERVAL = "1000";
    public static final String DEFAULT_HB_TOLERANCE = "3000";
    public static final String DEFAULT_CONNECT_TIMEOUT = "1000";
    private static final Attributes SIMPLE_CLIENT_ATTRIBUTES = new Attributes();
    private State state;
    private final NetworkManager<T> network;
    private final ChannelListener<T> listener;
    private final Host serverAddress;
    private Connection<T> connection;

    public SimpleClientChannel(ISerializer<T> serializer, ChannelListener<T> list, Properties properties) throws UnknownHostException {
        super(NAME);
        this.listener = list;
        if (!properties.containsKey(ADDRESS_KEY)) {
            throw new IllegalArgumentException("ClientChannel requires server address");
        }
        InetAddress addr = Inet4Address.getByName(properties.getProperty(ADDRESS_KEY));
        int port = Integer.parseInt(properties.getProperty(PORT_KEY, DEFAULT_PORT));
        int hbInterval = Integer.parseInt(properties.getProperty(HEARTBEAT_INTERVAL_KEY, "1000"));
        int hbTolerance = Integer.parseInt(properties.getProperty(HEARTBEAT_TOLERANCE_KEY, DEFAULT_HB_TOLERANCE));
        int connTimeout = Integer.parseInt(properties.getProperty(CONNECT_TIMEOUT_KEY, "1000"));
        this.serverAddress = new Host(addr, port);
        EventLoopGroup eventExecutors = properties.containsKey(WORKER_GROUP_KEY) ? (EventLoopGroup)properties.get(WORKER_GROUP_KEY) : NetworkManager.createNewWorkerGroup();
        this.network = new NetworkManager<T>(serializer, this, hbInterval, hbTolerance, connTimeout, eventExecutors);
        this.state = State.DISCONNECTED;
        this.connection = null;
    }

    @Override
    protected void onOpenConnection(Host peer, int conn) {
        this.connection = this.network.createConnection(this.serverAddress, SIMPLE_CLIENT_ATTRIBUTES, this);
        this.state = State.CONNECTING;
    }

    @Override
    protected void onCloseConnection(Host peer, int conn) {
        this.connection.disconnect();
        this.connection = null;
        this.state = State.DISCONNECTED;
    }

    @Override
    protected void onSendMessage(T msg, Host peer, int conn) {
        if (peer == null) {
            peer = this.serverAddress;
        }
        if (!peer.equals(this.serverAddress)) {
            this.listener.messageFailed(msg, peer, new Exception("Invalid Host"));
            return;
        }
        if (this.state != State.CONNECTED) {
            this.listener.messageFailed(msg, peer, new Exception("Connection not established"));
            return;
        }
        Promise promise = this.loop.newPromise();
        Host finalPeer = peer;
        promise.addListener(future -> {
            if (!future.isSuccess()) {
                this.listener.messageFailed(msg, finalPeer, future.cause());
            } else {
                this.listener.messageSent(msg, finalPeer);
            }
        });
        this.connection.sendMessage(msg, (Promise<Void>)promise);
    }

    @Override
    public void onDeliverMessage(T msg, Connection<T> conn) {
        this.listener.deliverMessage(msg, conn.getPeer());
    }

    @Override
    protected void onOutboundConnectionUp(Connection<T> conn) {
        this.connection = conn;
        this.state = State.CONNECTED;
        logger.debug("Server up: " + String.valueOf(conn));
        this.listener.deliverEvent(new ServerUpEvent(conn.getPeer()));
    }

    @Override
    protected void onOutboundConnectionDown(Connection<T> conn, Throwable cause) {
        this.connection = null;
        logger.debug("Server down: " + String.valueOf(conn) + " ... " + String.valueOf(cause));
        this.listener.deliverEvent(new ServerDownEvent(conn.getPeer(), cause));
        this.connection = null;
        this.state = State.DISCONNECTED;
    }

    @Override
    protected void onOutboundConnectionFailed(Connection<T> conn, Throwable cause) {
        logger.debug("Server con failed: " + String.valueOf(conn) + " ... " + String.valueOf(cause));
        this.connection = null;
        this.listener.deliverEvent(new ServerFailedEvent(conn.getPeer(), cause));
        this.connection = null;
        this.state = State.DISCONNECTED;
    }

    static {
        SIMPLE_CLIENT_ATTRIBUTES.putShort("magic_number", (short)23749);
    }

    public static enum State {
        CONNECTING,
        CONNECTED,
        DISCONNECTED;

    }
}

