/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.simpleclientserver;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Promise;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.channel.ChannelListener;
import pt.unl.fct.di.novasys.channel.base.SingleThreadedServerChannel;
import pt.unl.fct.di.novasys.channel.simpleclientserver.events.ClientDownEvent;
import pt.unl.fct.di.novasys.channel.simpleclientserver.events.ClientUpEvent;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.NetworkManager;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;

public class SimpleServerChannel<T>
extends SingleThreadedServerChannel<T, T>
implements AttributeValidator {
    private static final Logger logger = LogManager.getLogger(SimpleServerChannel.class);
    public static final String NAME = "ServerChannel";
    public static final String ADDRESS_KEY = "address";
    public static final String PORT_KEY = "port";
    public static final String WORKER_GROUP_KEY = "worker_group";
    public static final String HEARTBEAT_INTERVAL_KEY = "heartbeat_interval";
    public static final String HEARTBEAT_TOLERANCE_KEY = "heartbeat_tolerance";
    public static final String CONNECT_TIMEOUT_KEY = "connect_timeout";
    public static final String TRIGGER_SENT_KEY = "trigger_sent";
    public static final String DEFAULT_PORT = "13174";
    public static final String DEFAULT_HB_INTERVAL = "1000";
    public static final String DEFAULT_HB_TOLERANCE = "3000";
    public static final String DEFAULT_CONNECT_TIMEOUT = "1000";
    private final NetworkManager<T> network;
    private final ChannelListener<T> listener;
    private final Map<Host, Connection<T>> clientConnections;
    private final boolean triggerSent;

    public SimpleServerChannel(ISerializer<T> serializer, ChannelListener<T> list, Properties properties) throws UnknownHostException {
        super(NAME);
        this.listener = list;
        this.clientConnections = new HashMap<Host, Connection<T>>();
        if (!properties.containsKey(ADDRESS_KEY)) {
            throw new IllegalArgumentException("ServerChannel requires binding address");
        }
        InetAddress addr = Inet4Address.getByName(properties.getProperty(ADDRESS_KEY));
        int port = Integer.parseInt(properties.getProperty(PORT_KEY, DEFAULT_PORT));
        int hbInterval = Integer.parseInt(properties.getProperty(HEARTBEAT_INTERVAL_KEY, "1000"));
        int hbTolerance = Integer.parseInt(properties.getProperty(HEARTBEAT_TOLERANCE_KEY, DEFAULT_HB_TOLERANCE));
        int connTimeout = Integer.parseInt(properties.getProperty(CONNECT_TIMEOUT_KEY, "1000"));
        this.triggerSent = Boolean.parseBoolean(properties.getProperty(TRIGGER_SENT_KEY, "false"));
        Host listenAddress = new Host(addr, port);
        EventLoopGroup eventExecutors = properties.containsKey(WORKER_GROUP_KEY) ? (EventLoopGroup)properties.get(WORKER_GROUP_KEY) : NetworkManager.createNewWorkerGroup();
        this.network = new NetworkManager<T>(serializer, this, hbInterval, hbTolerance, connTimeout, null);
        this.network.createServerSocket(this, listenAddress, (AttributeValidator)this, eventExecutors);
    }

    @Override
    protected void onSendMessage(T msg, Host peer, int connection) {
        Connection<T> conn = this.clientConnections.get(peer);
        if (conn != null) {
            Promise promise = this.loop.newPromise();
            promise.addListener(future -> {
                if (future.isSuccess() && this.triggerSent) {
                    this.listener.messageSent(msg, peer);
                } else if (!future.isSuccess()) {
                    this.listener.messageFailed(msg, peer, future.cause());
                }
            });
            conn.sendMessage(msg, (Promise<Void>)promise);
        } else {
            this.listener.messageFailed(msg, peer, new Exception("No client connection from :" + String.valueOf(peer)));
        }
    }

    @Override
    protected void onCloseConnection(Host peer, int connection) {
        Connection<T> remove = this.clientConnections.remove(peer);
        if (remove != null) {
            remove.disconnect();
        }
    }

    @Override
    protected void onInboundConnectionUp(Connection<T> con) {
        logger.debug("Inbound up: " + String.valueOf(con));
        this.clientConnections.put(con.getPeer(), con);
        this.listener.deliverEvent(new ClientUpEvent(con.getPeer()));
    }

    @Override
    protected void onInboundConnectionDown(Connection<T> con, Throwable cause) {
        logger.debug("Inbound down: " + String.valueOf(con) + " ... " + String.valueOf(cause));
        this.clientConnections.remove(con.getPeer());
        this.listener.deliverEvent(new ClientDownEvent(con.getPeer(), cause));
    }

    @Override
    public void onServerSocketBind(boolean success, Throwable cause) {
        if (success) {
            logger.debug("Server socket ready");
        } else {
            logger.error("Server socket bind failed: " + String.valueOf(cause));
        }
    }

    @Override
    public void onServerSocketClose(boolean success, Throwable cause) {
        logger.debug("Server socket closed. " + (String)(success ? "" : "Cause: " + String.valueOf(cause)));
    }

    @Override
    public void onDeliverMessage(T msg, Connection<T> conn) {
        this.listener.deliverMessage(msg, conn.getPeer());
    }

    @Override
    protected void onOpenConnection(Host peer, int connection) {
        throw new UnsupportedOperationException("I am Server, not Client");
    }

    @Override
    public boolean validateAttributes(Attributes attr) {
        Short channel = attr.getShort("magic_number");
        return channel != null && channel == 23749;
    }
}

