/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.channel.tcp;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.channel.ChannelListener;
import pt.unl.fct.di.novasys.channel.tcp.TCPChannel;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class SharedTCPChannel<T>
extends TCPChannel<T> {
    private static final Logger logger = LogManager.getLogger(SharedTCPChannel.class);
    private final Map<Host, Map<Integer, Object>> connections = new ConcurrentHashMap<Host, Map<Integer, Object>>();
    public static final String NAME = "SharedTCPChannel";

    public SharedTCPChannel(ISerializer<T> serializer, ChannelListener<T> list, Properties properties) throws IOException {
        super(serializer, list, properties);
    }

    @Override
    protected void onOpenConnection(Host peer, int connection) {
        super.onOpenConnection(peer, connection);
        this.addConnection(peer, connection);
    }

    @Override
    protected void onCloseConnection(Host peer, int connection) {
        Map<Integer, Object> openConnections = this.removeConnection(peer, connection);
        if (openConnections == null || openConnections.isEmpty()) {
            super.onCloseConnection(peer, connection);
        }
    }

    private Map<Integer, Object> addConnection(Host peer, int connection) {
        Map openConnections = this.connections.computeIfAbsent(peer, k -> new ConcurrentHashMap());
        openConnections.put(connection, new Object());
        return openConnections;
    }

    private Map<Integer, Object> removeConnection(Host peer, int connection) {
        Map<Integer, Object> openConnections = this.connections.get(peer);
        if (openConnections != null) {
            openConnections.remove(connection);
        }
        return openConnections;
    }
}

