/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.messaging.control;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;

public class FirstHandshakeMessage
extends ControlMessage {
    static ControlMessage.ControlMessageSerializer serializer = new ControlMessage.ControlMessageSerializer<FirstHandshakeMessage>(){

        @Override
        public void serialize(FirstHandshakeMessage msg, ByteBuf out) throws IOException {
            out.writeInt(msg.magicNumber);
            Attributes.serializer.serialize(msg.attributes, out);
        }

        @Override
        public FirstHandshakeMessage deserialize(ByteBuf in) throws IOException {
            int magicNumber = in.readInt();
            if (magicNumber != 2036819058) {
                throw new RuntimeException("Invalid magic number: " + magicNumber);
            }
            Attributes attributes = Attributes.serializer.deserialize(in);
            return new FirstHandshakeMessage(magicNumber, attributes);
        }
    };
    public final int magicNumber;
    public final Attributes attributes;

    public FirstHandshakeMessage(Attributes attributes) {
        this(2036819058, attributes);
    }

    public FirstHandshakeMessage(int magicNumber, Attributes attributes) {
        super(ControlMessage.Type.FIRST_HS);
        this.attributes = attributes;
        this.magicNumber = magicNumber;
    }

    public String toString() {
        return "FirstHandshakeMessage{attributes=" + String.valueOf(this.attributes) + ", magicNumber=" + this.magicNumber + "}";
    }
}

