/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.messaging.control;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;

public class NthHandshakeMessage
extends ControlMessage {
    static ControlMessage.ControlMessageSerializer serializer = new ControlMessage.ControlMessageSerializer<NthHandshakeMessage>(){

        @Override
        public void serialize(NthHandshakeMessage msg, ByteBuf out) throws IOException {
            out.writeInt(msg.magicNumber);
            out.writeByte((int)msg.handshakeStep);
            Attributes.serializer.serialize(msg.attributes, out);
        }

        @Override
        public NthHandshakeMessage deserialize(ByteBuf in) throws IOException {
            int magicNumber = in.readInt();
            if (magicNumber != 2036819058) {
                throw new RuntimeException("Invalid magic number: " + magicNumber);
            }
            byte handshakeStep = in.readByte();
            Attributes attributes = Attributes.serializer.deserialize(in);
            return new NthHandshakeMessage(magicNumber, attributes, handshakeStep);
        }
    };
    public final int magicNumber;
    public final Attributes attributes;
    public final byte handshakeStep;

    public NthHandshakeMessage(Attributes attributes, int handshakeStep) {
        this(attributes, (byte)handshakeStep);
    }

    public NthHandshakeMessage(Attributes attributes, byte handshakeStep) {
        this(2036819058, attributes, handshakeStep);
    }

    public NthHandshakeMessage(int magicNumber, Attributes attributes, int handshakeStep) {
        this(magicNumber, attributes, (byte)handshakeStep);
    }

    public NthHandshakeMessage(int magicNumber, Attributes attributes, byte handshakeStep) {
        super(ControlMessage.Type.NTH_HS);
        this.attributes = attributes;
        this.magicNumber = magicNumber;
        this.handshakeStep = handshakeStep;
    }

    public String toString() {
        return "NthHandshakeMessage{attributes=" + String.valueOf(this.attributes) + ", magicNumber=" + this.magicNumber + ", handshakeStep=" + this.handshakeStep + "}";
    }
}

